/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.validator;

import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.MatchPredicate;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.WindowFunction;
import java.util.Locale;

public class GroupBySymbolValidator {
    private static final InnerValidator INNER_VALIDATOR = new InnerValidator();

    public static void validate(Symbol symbol) throws IllegalArgumentException, UnsupportedOperationException {
        symbol.accept(INNER_VALIDATOR, false);
    }

    private static class InnerValidator
    extends SymbolVisitor<Boolean, Void> {
        private InnerValidator() {
        }

        @Override
        public Void visitFunction(Function function, Boolean insideScalar) {
            switch (function.signature().getType()) {
                case SCALAR: {
                    for (Symbol argument : function.arguments()) {
                        argument.accept(this, true);
                    }
                    break;
                }
                case AGGREGATE: {
                    throw new IllegalArgumentException("Aggregate functions are not allowed in GROUP BY");
                }
                case TABLE: {
                    if (insideScalar.booleanValue()) break;
                    throw new IllegalArgumentException("Table functions are not allowed in GROUP BY");
                }
                default: {
                    throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "FunctionInfo.Type %s not handled", new Object[]{function.signature().getType()}));
                }
            }
            return null;
        }

        @Override
        public Void visitWindowFunction(WindowFunction symbol, Boolean insideScalar) {
            throw new IllegalArgumentException("Window functions are not allowed in GROUP BY");
        }

        @Override
        public Void visitMatchPredicate(MatchPredicate matchPredicate, Boolean insideScalar) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "%s predicate cannot be used in a GROUP BY clause", "match"));
        }

        @Override
        protected Void visitSymbol(Symbol symbol, Boolean insideScalar) {
            return null;
        }

        @Override
        public Void visitAlias(AliasSymbol aliasSymbol, Boolean insideScalar) {
            return aliasSymbol.symbol().accept(this, insideScalar);
        }
    }
}

