/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.validator;

import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.WindowFunction;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Reference;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class HavingSymbolValidator {
    private static final InnerValidator INNER_VALIDATOR = new InnerValidator();

    public static void validate(Symbol symbol, @Nullable List<Symbol> groupBySymbols) throws IllegalArgumentException {
        symbol.accept(INNER_VALIDATOR, new HavingContext(groupBySymbols));
    }

    private static class InnerValidator
    extends SymbolVisitor<HavingContext, Void> {
        private InnerValidator() {
        }

        private static void ensurePresentInGroupBY(Symbol symbol, HavingContext context) {
            if (!context.insideAggregation && !context.groupByContains(symbol)) {
                throw new IllegalArgumentException(Symbols.format("Cannot use column %s outside of an Aggregation in HAVING clause. Only GROUP BY keys allowed here.", symbol));
            }
        }

        @Override
        public Void visitField(ScopedSymbol field, HavingContext context) {
            InnerValidator.ensurePresentInGroupBY(field, context);
            return null;
        }

        @Override
        public Void visitReference(Reference ref, HavingContext context) {
            InnerValidator.ensurePresentInGroupBY(ref, context);
            return null;
        }

        @Override
        public Void visitFunction(Function function, HavingContext context) {
            FunctionType type = function.signature().getType();
            if (type == FunctionType.TABLE) {
                throw new IllegalArgumentException("Table functions are not allowed in HAVING");
            }
            if (type == FunctionType.AGGREGATE) {
                context.insideAggregation = true;
            } else if (context.groupByContains(function)) {
                return null;
            }
            for (Symbol argument : function.arguments()) {
                argument.accept(this, context);
            }
            if (type == FunctionType.AGGREGATE) {
                context.insideAggregation = false;
            }
            return null;
        }

        @Override
        public Void visitWindowFunction(WindowFunction symbol, HavingContext context) {
            throw new IllegalArgumentException("Window functions are not allowed in HAVING");
        }

        @Override
        protected Void visitSymbol(Symbol symbol, HavingContext context) {
            return null;
        }
    }

    static class HavingContext {
        @Nullable
        private final List<Symbol> groupBySymbols;
        private boolean insideAggregation = false;

        HavingContext(@Nullable List<Symbol> groupBySymbols) {
            this.groupBySymbols = groupBySymbols;
        }

        boolean groupByContains(Symbol symbol) {
            return this.groupBySymbols != null && this.groupBySymbols.contains(symbol);
        }
    }
}

