/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.where;

import io.crate.analyze.ScalarsAndRefsToTrue;
import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.common.StringUtils;
import io.crate.common.collections.Iterables;
import io.crate.common.collections.Lists;
import io.crate.common.collections.Tuple;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.reference.partitioned.PartitionExpression;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.PartitionReferenceResolver;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.doc.DocTableInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.Metadata;
import org.jetbrains.annotations.Nullable;

public class WhereClauseAnalyzer {
    public static WhereClause resolvePartitions(WhereClause where, AbstractTableRelation<?> tableRelation, CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, Metadata metadata) {
        if (!where.hasQuery() || !(tableRelation instanceof DocTableRelation) || Literal.BOOLEAN_TRUE.equals(where.query())) {
            return where;
        }
        DocTableInfo table = (DocTableInfo)((DocTableRelation)tableRelation).tableInfo();
        if (!table.isPartitioned()) {
            return where;
        }
        if (table.getPartitionNames(metadata).isEmpty()) {
            return WhereClause.NO_MATCH;
        }
        PartitionResult partitionResult = WhereClauseAnalyzer.resolvePartitions(where.queryOrFallback(), table, coordinatorTxnCtx, nodeCtx, metadata);
        if (!(where.partitions().isEmpty() || partitionResult.partitions.isEmpty() || partitionResult.partitions.equals(where.partitions()))) {
            throw new IllegalArgumentException("Given partition ident does not match partition evaluated from where clause");
        }
        return new WhereClause(partitionResult.query, partitionResult.partitions, where.clusteredBy());
    }

    private static PartitionReferenceResolver preparePartitionResolver(List<Reference> partitionColumns) {
        ArrayList<PartitionExpression> partitionExpressions = new ArrayList<PartitionExpression>(partitionColumns.size());
        int idx = 0;
        for (Reference partitionedByColumn : partitionColumns) {
            partitionExpressions.add(new PartitionExpression(partitionedByColumn, idx));
            ++idx;
        }
        return new PartitionReferenceResolver(partitionExpressions);
    }

    public static PartitionResult resolvePartitions(Symbol query, DocTableInfo tableInfo, CoordinatorTxnCtx coordinatorTxnCtx, NodeContext nodeCtx, Metadata metadata) {
        assert (tableInfo.isPartitioned()) : "table must be partitioned in order to resolve partitions";
        assert (!tableInfo.getPartitionNames(metadata).isEmpty()) : "table must have at least one partition";
        PartitionReferenceResolver partitionReferenceResolver = WhereClauseAnalyzer.preparePartitionResolver(tableInfo.partitionedByColumns());
        EvaluatingNormalizer normalizer = new EvaluatingNormalizer(nodeCtx, RowGranularity.PARTITION, partitionReferenceResolver, null);
        HashMap queryPartitionMap = new HashMap();
        for (PartitionName partitionName : tableInfo.getPartitionNames(metadata)) {
            for (PartitionExpression partitionExpression : partitionReferenceResolver.expressions()) {
                partitionExpression.setNextRow(partitionName);
            }
            Symbol normalized = normalizer.normalize(query, coordinatorTxnCtx);
            assert (normalized != null) : "normalizing a query must not return null";
            if (normalized.equals(query)) {
                return new PartitionResult(query, Collections.emptyList());
            }
            boolean canMatch = WhereClause.canMatch(normalized);
            if (!canMatch) continue;
            ArrayList<Literal<String>> partitions = (ArrayList<Literal<String>>)queryPartitionMap.get(normalized);
            if (partitions == null) {
                partitions = new ArrayList<Literal<String>>();
                queryPartitionMap.put(normalized, partitions);
            }
            partitions.add(Literal.of(partitionName.asIndexName()));
        }
        if (queryPartitionMap.isEmpty()) {
            return new PartitionResult(Literal.BOOLEAN_FALSE, Collections.emptyList());
        }
        if (queryPartitionMap.size() == 1) {
            Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(queryPartitionMap.entrySet());
            return new PartitionResult((Symbol)entry.getKey(), Lists.map((Collection)((Collection)entry.getValue()), literal -> StringUtils.nullOrString(literal.value())));
        }
        PartitionResult partitionResult = WhereClauseAnalyzer.tieBreakPartitionQueries(normalizer, queryPartitionMap, coordinatorTxnCtx);
        return partitionResult == null ? new PartitionResult(query, Lists.map(tableInfo.getPartitionNames(metadata), PartitionName::asIndexName)) : partitionResult;
    }

    @Nullable
    private static PartitionResult tieBreakPartitionQueries(EvaluatingNormalizer normalizer, Map<Symbol, List<Literal<?>>> queryPartitionMap, CoordinatorTxnCtx coordinatorTxnCtx) throws UnsupportedOperationException {
        ArrayList<Tuple> canMatch = new ArrayList<Tuple>();
        for (Map.Entry<Symbol, List<Literal<?>>> entry : queryPartitionMap.entrySet()) {
            Symbol query = entry.getKey();
            List<Literal<?>> partitions = entry.getValue();
            Symbol normalized = normalizer.normalize(ScalarsAndRefsToTrue.rewrite(normalizer, coordinatorTxnCtx, query), coordinatorTxnCtx);
            assert (normalized instanceof Literal) : "after normalization and replacing all reference occurrences with true there must only be a literal left";
            Object value = ((Literal)normalized).value();
            if (value == null || !((Boolean)value).booleanValue()) continue;
            canMatch.add(new Tuple((Object)query, partitions));
        }
        if (canMatch.size() == 1) {
            Tuple symbolListTuple = (Tuple)canMatch.get(0);
            return new PartitionResult((Symbol)symbolListTuple.v1(), Lists.map((Collection)((Collection)symbolListTuple.v2()), literal -> StringUtils.nullOrString(literal.value())));
        }
        return null;
    }

    public static class PartitionResult {
        public final Symbol query;
        public final List<String> partitions;

        PartitionResult(Symbol query, List<String> partitions) {
            this.query = query;
            this.partitions = partitions;
        }
    }
}

