/*
 * Decompiled with CFR 0.152.
 */
package io.crate.auth;

import io.crate.auth.AuthenticationMethod;
import io.crate.auth.Credentials;
import io.crate.auth.Protocol;
import io.crate.protocols.SSL;
import io.crate.protocols.postgres.ConnectionProperties;
import io.crate.role.Role;
import io.crate.role.Roles;
import java.security.cert.Certificate;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientCertAuth
implements AuthenticationMethod {
    private static final Logger LOGGER = LogManager.getLogger(ConnectionProperties.class);
    static final String NAME = "cert";
    private final Roles roles;

    ClientCertAuth(Roles roles) {
        this.roles = roles;
    }

    @Override
    @Nullable
    public Role authenticate(Credentials credentials, ConnectionProperties connProperties) {
        String username = credentials.username();
        assert (username != null) : "User name must be not null on cert authentication method";
        Certificate clientCert = connProperties.clientCert();
        if (clientCert != null) {
            String commonName = SSL.extractCN(clientCert);
            if (Objects.equals(username, commonName) || connProperties.protocol() == Protocol.TRANSPORT) {
                Role user = this.roles.findUser(username);
                if (user != null) {
                    return user;
                }
            } else {
                throw new RuntimeException("Common name \"" + commonName + "\" in client certificate doesn't match username \"" + username + "\"");
            }
        }
        LOGGER.debug("Client certificate not available");
        throw new RuntimeException("Client certificate authentication failed for user \"" + username + "\"");
    }

    @Override
    public String name() {
        return NAME;
    }
}

