/*
 * Decompiled with CFR 0.152.
 */
package io.crate.blob;

import io.crate.blob.RemoteDigestBlob;
import io.crate.blob.exceptions.MissingHTTPEndpointException;
import io.crate.blob.transfer.BlobHeadRequestHandler;
import io.crate.blob.v2.BlobIndex;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.blob.v2.BlobShard;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.index.shard.ShardId;

public class BlobService
extends AbstractLifecycleComponent {
    private final BlobIndicesService blobIndicesService;
    private final BlobHeadRequestHandler blobHeadRequestHandler;
    private final ClusterService clusterService;
    private final Client client;

    public BlobService(ClusterService clusterService, BlobIndicesService blobIndicesService, BlobHeadRequestHandler blobHeadRequestHandler, Client client) {
        this.clusterService = clusterService;
        this.blobIndicesService = blobIndicesService;
        this.blobHeadRequestHandler = blobHeadRequestHandler;
        this.client = client;
    }

    public RemoteDigestBlob newBlob(String index, String digest) {
        assert (this.client != null) : "client for remote digest blob must not be null";
        ShardId shardId = this.clusterService.operationRouting().indexShards(this.clusterService.state(), index, digest, null).shardId();
        return new RemoteDigestBlob(this.client, shardId, digest);
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        this.blobHeadRequestHandler.registerHandler();
    }

    @Override
    protected void doStop() throws ElasticsearchException {
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    public String getRedirectAddress(String index, String digest) throws MissingHTTPEndpointException {
        ShardRouting shard;
        ShardIterator shards = this.clusterService.operationRouting().getShards(this.clusterService.state(), index, null, digest, "_local");
        String localNodeId = this.clusterService.localNode().getId();
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        while ((shard = shards.nextOrNull()) != null) {
            if (!shard.active()) continue;
            if (shard.currentNodeId().equals(localNodeId)) {
                return null;
            }
            DiscoveryNode node = nodes.get(shard.currentNodeId());
            String httpAddress = node.getAttributes().get("http_address");
            if (httpAddress == null) continue;
            return httpAddress + "/_blobs/" + BlobIndex.stripPrefix(index) + "/" + digest;
        }
        throw new MissingHTTPEndpointException("Can't find a suitable http server to serve the blob");
    }

    public BlobShard localBlobShard(String index, String digest) {
        return this.blobIndicesService.localBlobShard(index, digest);
    }
}

