/*
 * Decompiled with CFR 0.152.
 */
package io.crate.breaker;

import io.crate.breaker.CellsSizeEstimator;
import io.crate.data.breaker.RamAccounting;
import io.crate.data.breaker.RowAccounting;
import io.crate.types.DataType;
import java.util.List;

public class TypedCellsAccounting
implements RowAccounting<Object[]> {
    private final RamAccounting ramAccounting;
    private final int extraSizePerRow;
    private final CellsSizeEstimator sizeEstimator;

    public TypedCellsAccounting(List<? extends DataType<?>> columnTypes, RamAccounting ramAccounting, int extraSizePerRow) {
        this.sizeEstimator = CellsSizeEstimator.forColumns(columnTypes);
        this.ramAccounting = ramAccounting;
        this.extraSizePerRow = extraSizePerRow;
    }

    public long accountForAndMaybeBreak(Object[] rowCells) {
        long rowBytes = this.sizeEstimator.estimateSize(rowCells) + (long)this.extraSizePerRow;
        this.ramAccounting.addBytes(rowBytes);
        return rowBytes;
    }

    public void release() {
        this.ramAccounting.release();
    }
}

