/*
 * Decompiled with CFR 0.152.
 */
package io.crate.cluster.commands;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.common.collections.Maps;
import io.crate.common.collections.Tuple;
import io.crate.execution.ddl.Templates;
import io.crate.metadata.IndexName;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import joptsimple.OptionSet;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.gateway.PersistedClusterStateService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class FixCorruptedMetadataCommand
extends ElasticsearchNodeCommand {
    public static final String METADATA_FIXED_MSG = "Metadata has been fixed";
    public static final String CONFIRMATION_MSG = "------------------------------------------------------------------------\n\nYou should only run this tool if you have ended up with corrupted metadata\nbecause of a table swap like: ALTER CLUSTER SWAP TABLE \"schema\".\"table\" TO \"schema.table\".\n\nDo you want to proceed?\n";

    public FixCorruptedMetadataCommand() {
        super("Fix corrupted metadata as a result of a table swap like: ALTER CLUSTER SWAP TABLE \"myschema\".\"mytable\" TO \"myschema.mytable\"");
    }

    @Override
    public void processNodePaths(Terminal terminal, Path[] dataPaths, OptionSet options, Environment env) throws IOException {
        terminal.println(Terminal.Verbosity.VERBOSE, "Loading cluster state");
        PersistedClusterStateService persistedClusterStateService = FixCorruptedMetadataCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        Tuple<Long, ClusterState> termAndClusterState = FixCorruptedMetadataCommand.loadTermAndClusterState(persistedClusterStateService, env);
        long currentTerm = (Long)termAndClusterState.v1();
        ClusterState oldClusterState = (ClusterState)termAndClusterState.v2();
        Metadata oldMetadata = persistedClusterStateService.loadBestOnDiskState().metadata;
        Metadata.Builder fixedMetadata = Metadata.builder(oldMetadata);
        FixCorruptedMetadataCommand.fixNameOfTemplateMetadata(oldMetadata.templates(), fixedMetadata);
        for (IndexMetadata indexMetadata : oldMetadata) {
            FixCorruptedMetadataCommand.fixNameOfIndexMetadata(indexMetadata, fixedMetadata);
        }
        for (IndexMetadata indexMetadata : oldMetadata) {
            FixCorruptedMetadataCommand.fixInconsistencyBetweenIndexAndTemplates(indexMetadata, fixedMetadata);
        }
        ClusterState newClusterState = ClusterState.builder(oldClusterState).metadata(fixedMetadata.build()).build();
        terminal.println(Terminal.Verbosity.VERBOSE, "[old cluster state = " + String.valueOf(oldClusterState) + ", new cluster state = " + String.valueOf(newClusterState) + "]");
        this.confirm(terminal, CONFIRMATION_MSG);
        try (PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();){
            writer.writeFullStateAndCommit(currentTerm, newClusterState);
        }
        terminal.println(METADATA_FIXED_MSG);
    }

    @VisibleForTesting
    static void fixInconsistencyBetweenIndexAndTemplates(IndexMetadata indexMetadata, Metadata.Builder fixedMetadata) {
        String indexName = indexMetadata.getIndex().getName();
        String[] indexParts = indexName.split("\\.");
        MappingMetadata mappingMetadata = indexMetadata.mapping();
        if (mappingMetadata != null && !IndexName.isPartitioned(indexName) && indexParts.length == 2) {
            Map metaMap = (Map)Maps.get(mappingMetadata.sourceAsMap(), (String)"_meta");
            if (metaMap != null && metaMap.containsKey("partitioned_by")) {
                List partitionedByColumns = (List)Maps.get((Map)metaMap, (String)"partitioned_by");
                fixedMetadata.remove(indexName);
                fixedMetadata.put(FixCorruptedMetadataCommand.generatePartitionedIndexMetadata(indexName, indexMetadata, partitionedByColumns));
                String templateName = PartitionName.templateName(indexParts[0], indexParts[1]);
                ImmutableOpenMap.Builder<String, IndexTemplateMetadata> mapBuilder = ImmutableOpenMap.builder();
                mapBuilder.put(templateName, FixCorruptedMetadataCommand.generateTemplateIndexMetadata(indexName, indexMetadata, mappingMetadata).build());
                fixedMetadata.removeTemplate(templateName);
                fixedMetadata.templates(mapBuilder.build());
            } else {
                fixedMetadata.removeTemplate(PartitionName.templateName(indexParts[0], indexParts[1]));
            }
        }
    }

    private static IndexTemplateMetadata.Builder generateTemplateIndexMetadata(String indexName, IndexMetadata indexMetadata, MappingMetadata mappingMetadata) {
        String[] indexParts = indexName.split("\\.");
        String templateName = PartitionName.templateName(indexParts[0], indexParts[1]);
        IndexTemplateMetadata.Builder templateBuilder = new IndexTemplateMetadata.Builder(templateName);
        templateBuilder.putAlias(new AliasMetadata(indexName));
        templateBuilder.putMapping(mappingMetadata.source());
        Settings indexSettings = indexMetadata.getSettings();
        Settings templateCompatibleSettings = indexSettings.filter(k -> !k.equals("index.uuid") && !k.equals("index.creation_date"));
        templateBuilder.settings(templateCompatibleSettings);
        templateBuilder.patterns(List.of(PartitionName.templatePrefix(indexParts[0], indexParts[1])));
        return templateBuilder;
    }

    private static IndexMetadata.Builder generatePartitionedIndexMetadata(String indexName, IndexMetadata indexMetadata, List<List<String>> partitionedByColumns) {
        String[] indexParts = indexName.split("\\.");
        IndexMetadata.Builder partitionedIndexMetadata = new IndexMetadata.Builder(indexMetadata);
        partitionedIndexMetadata.putAlias(new AliasMetadata(indexName));
        String partitionedIndexName = new PartitionName(new RelationName(indexParts[0], indexParts[1]), partitionedByColumns.stream().map(c -> null).toList()).toString();
        partitionedIndexMetadata.index(partitionedIndexName);
        return partitionedIndexMetadata;
    }

    @VisibleForTesting
    static void fixNameOfTemplateMetadata(ImmutableOpenMap<String, IndexTemplateMetadata> templates, Metadata.Builder fixedMetadata) {
        for (ObjectObjectCursor<String, IndexTemplateMetadata> objectObjectCursor : templates) {
            RelationName fixedRelationName = FixCorruptedMetadataCommand.fixTemplateName((String)objectObjectCursor.key);
            if (fixedRelationName != null) {
                fixedMetadata.removeTemplate((String)objectObjectCursor.key);
                fixedMetadata.put(Templates.withName((IndexTemplateMetadata)objectObjectCursor.value, fixedRelationName).build());
                continue;
            }
            if (fixedMetadata.getTemplate((String)objectObjectCursor.key) != null) continue;
            fixedMetadata.put((IndexTemplateMetadata)objectObjectCursor.value);
        }
    }

    @VisibleForTesting
    static RelationName fixTemplateName(@NotNull String templateName) {
        String[] parts;
        if (templateName.startsWith(".partitioned") && (parts = templateName.split("\\.")).length == 4 && parts[0].isEmpty() && parts[1].equals("partitioned")) {
            return new RelationName(parts[2], parts[3]);
        }
        return null;
    }

    private static void fixNameOfIndexMetadata(IndexMetadata indexMetadata, Metadata.Builder fixedMetadata) {
        String indexName = indexMetadata.getIndex().getName();
        String fixedName = FixCorruptedMetadataCommand.fixIndexName(indexName);
        if (fixedName != null) {
            IndexMetadata corrupted = fixedMetadata.get(indexName);
            fixedMetadata.remove(indexName);
            fixedMetadata.put(IndexMetadata.builder(corrupted).index(fixedName));
        }
    }

    @VisibleForTesting
    static String fixIndexName(@NotNull String indexName) {
        block3: {
            if (indexName.startsWith(".partitioned")) {
                try {
                    IndexName.decode(indexName);
                }
                catch (IllegalArgumentException e) {
                    String[] indexParts = indexName.split("\\.");
                    if (indexParts.length != 5) break block3;
                    return IndexName.encode(indexParts[2], indexParts[3], indexParts[4]);
                }
            }
        }
        return null;
    }
}

