/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.ResourceUnknownException;
import io.crate.exceptions.TableScopeException;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.Collections;
import java.util.Locale;

public class PartitionUnknownException
extends RuntimeException
implements ResourceUnknownException,
TableScopeException {
    private final PartitionName partitionName;

    public PartitionUnknownException(PartitionName partitionName) {
        super(String.format(Locale.ENGLISH, "No partition for table '%s' with ident '%s' exists", partitionName.relationName().fqn(), partitionName.ident()));
        this.partitionName = partitionName;
    }

    public PartitionName partitionName() {
        return this.partitionName;
    }

    @Override
    public Iterable<RelationName> getTableIdents() {
        return Collections.singletonList(this.partitionName.relationName());
    }
}

