/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.ResourceUnknownException;
import io.crate.exceptions.TableScopeException;
import io.crate.metadata.RelationName;
import java.util.Collection;
import java.util.stream.Collectors;

public class RelationsUnknown
extends RuntimeException
implements ResourceUnknownException,
TableScopeException {
    private final Iterable<RelationName> relations;

    public RelationsUnknown(Collection<RelationName> relations) {
        super(RelationsUnknown.errorMsg(relations));
        this.relations = relations;
    }

    @Override
    public Iterable<RelationName> getTableIdents() {
        return this.relations;
    }

    private static String errorMsg(Collection<RelationName> relations) {
        return "Relations not found: " + relations.stream().map(RelationName::sqlFqn).collect(Collectors.joining(", "));
    }
}

