/*
 * Decompiled with CFR 0.152.
 */
package io.crate.exceptions;

import io.crate.exceptions.ResourceUnknownException;
import io.crate.exceptions.UnscopedException;
import io.crate.protocols.postgres.PGErrorStatus;
import io.crate.rest.action.HttpErrorStatus;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;

public class RoleUnknownException
extends ElasticsearchException
implements ResourceUnknownException,
UnscopedException {
    public RoleUnknownException(String roleName) {
        super(RoleUnknownException.getMessage(Collections.singletonList(roleName)), new Object[0]);
    }

    public RoleUnknownException(int oid) {
        super(String.format(Locale.ENGLISH, "Role with OID %d does not exist", oid), new Object[0]);
    }

    public RoleUnknownException(List<String> roleNames) {
        super(RoleUnknownException.getMessage(roleNames), new Object[0]);
    }

    public RoleUnknownException(StreamInput in) throws IOException {
        super(in);
    }

    private static String getMessage(List<String> roleNames) {
        assert (!roleNames.isEmpty()) : "At least one username must be provided";
        if (roleNames.size() == 1) {
            return String.format(Locale.ENGLISH, "Role '%s' does not exist", roleNames.get(0));
        }
        return String.format(Locale.ENGLISH, "Roles '%s' do not exist", String.join((CharSequence)", ", roleNames));
    }

    @Override
    public HttpErrorStatus httpErrorStatus() {
        return HttpErrorStatus.USER_UNKNOWN;
    }

    @Override
    public PGErrorStatus pgErrorStatus() {
        return PGErrorStatus.UNDEFINED_OBJECT;
    }
}

