/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl;

import io.crate.execution.ddl.tables.CreateTableRequest;
import io.crate.execution.ddl.tables.MappingUtil;
import io.crate.metadata.DocReferences;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexTemplateException;

public final class Templates {
    private static final Logger LOGGER = LogManager.getLogger(Templates.class);

    public static IndexTemplateMetadata.Builder withName(IndexTemplateMetadata source, RelationName newName) {
        String targetTemplateName = PartitionName.templateName(newName.schema(), newName.name());
        String targetAlias = newName.indexNameOrAlias();
        IndexTemplateMetadata.Builder templateBuilder = IndexTemplateMetadata.builder(targetTemplateName).patterns(Collections.singletonList(PartitionName.templatePrefix(newName.schema(), newName.name()))).settings(source.settings()).putMapping(source.mapping()).putAlias(new AliasMetadata(targetAlias)).version(source.version());
        return templateBuilder;
    }

    public static ClusterState add(IndicesService indicesService, MetadataCreateIndexService metadataIndexService, ClusterState clusterState, CreateTableRequest request, Settings settings) throws Exception {
        RelationName relationName = request.getTableName();
        String templateName = PartitionName.templateName(relationName.schema(), relationName.name());
        String templatePrefix = PartitionName.templatePrefix(relationName.schema(), relationName.name());
        Alias alias = new Alias(relationName.indexNameOrAlias());
        Templates.validate(metadataIndexService, templateName, templatePrefix, request.settings(), alias);
        String temporaryIndexName = UUIDs.randomBase64UUID();
        int dummyPartitionSize = IndexMetadata.INDEX_ROUTING_PARTITION_SIZE_SETTING.get(settings);
        int dummyShards = settings.getAsInt("index.number_of_shards", dummyPartitionSize == 1 ? 1 : dummyPartitionSize + 1);
        Settings dummySettings = Settings.builder().put("index.version.created", Version.CURRENT).put(settings).put("index.number_of_shards", dummyShards).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID()).build();
        IndexMetadata tmpIndexMetadata = IndexMetadata.builder(temporaryIndexName).settings(dummySettings).build();
        return (ClusterState)indicesService.withTempIndexService(tmpIndexMetadata, indexService -> {
            Version versionCreated = Version.min(Version.CURRENT, clusterState.nodes().getSmallestNonClientNodeVersion());
            Metadata.Builder metadataBuilder = Metadata.builder(clusterState.metadata());
            IndexTemplateMetadata.Builder templateBuilder = IndexTemplateMetadata.builder(templateName).version(null).patterns(List.of(templatePrefix)).putAlias(new AliasMetadata(alias.name())).settings(Settings.builder().put(settings).put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), versionCreated));
            List<Reference> references = DocReferences.applyOid(request.references(), metadataBuilder.columnOidSupplier());
            Map<String, Map<String, Object>> mapping = Map.of("default", MappingUtil.createMapping(MappingUtil.AllocPosition.forNewTable(), request.pkConstraintName(), references, request.pKeyIndices(), request.checkConstraints(), request.partitionedBy(), request.tableColumnPolicy(), request.routingColumn()));
            try {
                templateBuilder.putMapping(new CompressedXContent(Strings.toString(JsonXContent.builder().map(mapping))));
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping: {}", (Throwable)e, e.getMessage());
            }
            LOGGER.info("adding template [{}] for index pattern {}", (Object)templateName, (Object)templatePrefix);
            return ClusterState.builder(clusterState).metadata(metadataBuilder.put(templateBuilder)).build();
        });
    }

    private static void validate(MetadataCreateIndexService metadataIndexService, String templateName, String templatePrefix, Settings settings, Alias alias) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (templateName.contains(" ")) {
            validationErrors.add("name must not contain a space");
        }
        if (templateName.contains(",")) {
            validationErrors.add("name must not contain a ','");
        }
        if (templateName.contains("#")) {
            validationErrors.add("name must not contain a '#'");
        }
        if (templatePrefix.contains(" ")) {
            validationErrors.add("template must not contain a space");
        }
        if (templatePrefix.contains(",")) {
            validationErrors.add("template must not contain a ','");
        }
        if (templatePrefix.contains("#")) {
            validationErrors.add("template must not contain a '#'");
        }
        if (!Strings.validFileNameExcludingAstrix(templatePrefix)) {
            validationErrors.add("template must not contain the following characters " + String.valueOf(Strings.INVALID_FILENAME_CHARS));
        }
        List<String> indexSettingsValidation = metadataIndexService.getIndexSettingsValidationErrors(settings, true);
        validationErrors.addAll(indexSettingsValidation);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new InvalidIndexTemplateException(templateName, validationException.getMessage());
        }
        AliasValidator.validateAliasName(alias.name());
        if (templatePrefix.equals(alias.name())) {
            throw new IllegalArgumentException("Alias [" + alias.name() + "] cannot be the same as template prefix [" + templatePrefix + "]");
        }
    }
}

