/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.ddl.tables;

import io.crate.execution.ddl.AbstractDDLTransportAction;
import io.crate.execution.ddl.tables.AlterTableRequest;
import io.crate.metadata.NodeContext;
import io.crate.metadata.cluster.AlterTableClusterStateExecutor;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

@Singleton
public class TransportAlterTableAction
extends AbstractDDLTransportAction<AlterTableRequest, AcknowledgedResponse> {
    private static final String ACTION_NAME = "internal:crate:sql/table/alter";
    private final AlterTableClusterStateExecutor executor;

    @Inject
    public TransportAlterTableAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, IndicesService indicesService, IndexScopedSettings indexScopedSettings, MetadataCreateIndexService metadataCreateIndexService, MetadataUpdateSettingsService updateSettingsService, NodeContext nodeContext) {
        super(ACTION_NAME, transportService, clusterService, threadPool, AlterTableRequest::new, AcknowledgedResponse::new, AcknowledgedResponse::new, "alter-table");
        this.executor = new AlterTableClusterStateExecutor(indicesService, indexScopedSettings, metadataCreateIndexService, updateSettingsService, nodeContext);
    }

    @Override
    public ClusterStateTaskExecutor<AlterTableRequest> clusterStateTaskExecutor(AlterTableRequest request) {
        return this.executor;
    }

    @Override
    protected void masterOperation(AlterTableRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) throws Exception {
        if (state.nodes().getMinNodeVersion().before(Version.V_5_10_0)) {
            throw new IllegalStateException("Cannot alter table settings until all nodes are upgraded to 5.10");
        }
        super.masterOperation(request, state, listener);
    }

    @Override
    public ClusterBlockException checkBlock(AlterTableRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

