/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.SysColumns;
import io.crate.sql.tree.BitString;
import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.jetbrains.annotations.NotNull;

public class BitStringIndexer
implements ValueIndexer<BitString> {
    private static final FieldType FIELD_TYPE = new FieldType();
    private final Reference ref;
    private final String name;

    public BitStringIndexer(Reference ref) {
        this.ref = ref;
        this.name = ref.storageIdent();
    }

    @Override
    public void indexValue(@NotNull BitString value, IndexDocumentBuilder docBuilder) throws IOException {
        BitSet bitSet = value.bitSet();
        byte[] bytes = bitSet.toByteArray();
        BytesRef binaryValue = new BytesRef(bytes);
        if (this.ref.indexType() != IndexType.NONE) {
            docBuilder.addField((IndexableField)new Field(this.name, binaryValue, (IndexableFieldType)FIELD_TYPE));
        }
        if (this.ref.hasDocValues()) {
            docBuilder.addField((IndexableField)new SortedSetDocValuesField(this.name, binaryValue));
        } else {
            if (docBuilder.maybeAddStoredField()) {
                docBuilder.addField((IndexableField)new StoredField(this.name, binaryValue));
            }
            docBuilder.addField((IndexableField)new Field("_field_names", (CharSequence)this.name, (IndexableFieldType)SysColumns.FieldNames.FIELD_TYPE));
        }
        docBuilder.translogWriter().writeValue(bytes);
    }

    @Override
    public String storageIdentLeafName() {
        return this.ref.storageIdentLeafName();
    }

    static {
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.setTokenized(false);
        FIELD_TYPE.setStored(false);
        FIELD_TYPE.freeze();
    }
}

