/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.jetbrains.annotations.NotNull;

public class FulltextIndexer
implements ValueIndexer<String> {
    public static final FieldType FIELD_TYPE = new FieldType();
    private final Reference ref;

    public FulltextIndexer(Reference ref) {
        this.ref = ref;
    }

    @Override
    public void indexValue(@NotNull String value, IndexDocumentBuilder docBuilder) throws IOException {
        String name = this.ref.storageIdent();
        if (this.ref.indexType() != IndexType.NONE) {
            docBuilder.addField((IndexableField)new Field(name, (CharSequence)value, (IndexableFieldType)FIELD_TYPE));
        }
        docBuilder.translogWriter().writeValue(value);
        if (docBuilder.maybeAddStoredField()) {
            docBuilder.addField((IndexableField)new StoredField(name, value));
        }
    }

    @Override
    public String storageIdentLeafName() {
        return this.ref.storageIdentLeafName();
    }

    static {
        FIELD_TYPE.setTokenized(true);
        FIELD_TYPE.setStored(false);
        FIELD_TYPE.setStoreTermVectors(false);
        FIELD_TYPE.setOmitNorms(false);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        FIELD_TYPE.freeze();
    }
}

