/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.geo.GeoJSONUtils;
import io.crate.geo.LatLonShapeUtils;
import io.crate.metadata.GeneratedReference;
import io.crate.metadata.GeoReference;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.SysColumns;
import io.crate.types.GeoShapeType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.PackedQuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.unit.DistanceUnit;
import org.jetbrains.annotations.NotNull;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;

public class GeoShapeIndexer
implements ValueIndexer<Map<String, Object>> {
    private final IndexableFieldsFactory indexableFieldsFactory;
    private final Reference ref;
    private final String name;

    public GeoShapeIndexer(Reference ref) {
        if (ref instanceof GeneratedReference) {
            GeneratedReference generatedRef = (GeneratedReference)ref;
            ref = generatedRef.reference();
        }
        assert (ref instanceof GeoReference) : "GeoShapeIndexer requires GeoReference";
        GeoReference geoReference = (GeoReference)ref;
        this.name = ref.storageIdent();
        this.indexableFieldsFactory = "bkdtree".equals(geoReference.geoTree()) ? new BkdTreeIndexableFieldsFactory(this.name) : new PrefixTreeIndexableFieldsFactory(geoReference);
        this.ref = ref;
    }

    @Override
    public void indexValue(@NotNull Map<String, Object> value, IndexDocumentBuilder docBuilder) throws IOException {
        this.indexableFieldsFactory.create(value, docBuilder::addField);
        docBuilder.addField((IndexableField)new Field("_field_names", (CharSequence)this.name, (IndexableFieldType)SysColumns.FieldNames.FIELD_TYPE));
        docBuilder.translogWriter().writeValue(value);
        if (docBuilder.maybeAddStoredField()) {
            BytesRef bytes = GeoShapeIndexer.toBytes(value).toBytesRef();
            docBuilder.addField((IndexableField)new StoredField(this.name, bytes));
        }
    }

    private static BytesReference toBytes(Map<String, Object> shape) {
        BytesStreamOutput out = new BytesStreamOutput();
        try {
            GeoShapeType.INSTANCE.streamer().writeValueTo(out, shape);
            BytesReference bytesReference = out.bytes();
            out.close();
            return bytesReference;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public String storageIdentLeafName() {
        return this.ref.storageIdentLeafName();
    }

    private static class BkdTreeIndexableFieldsFactory
    implements IndexableFieldsFactory {
        private final String name;

        BkdTreeIndexableFieldsFactory(String name) {
            this.name = name;
        }

        @Override
        public void create(Map<String, Object> value, Consumer<? super IndexableField> addField) {
            Object shape = GeoJSONUtils.map2LuceneShape(value);
            LatLonShapeUtils.createIndexableFields(this.name, shape, addField);
        }
    }

    private static interface IndexableFieldsFactory {
        public void create(Map<String, Object> var1, Consumer<? super IndexableField> var2);
    }

    private static class PrefixTreeIndexableFieldsFactory
    implements IndexableFieldsFactory {
        private final RecursivePrefixTreeStrategy strategy;

        PrefixTreeIndexableFieldsFactory(GeoReference ref) {
            this.strategy = new RecursivePrefixTreeStrategy(this.prefixTree(ref), ref.storageIdent());
            Double distanceErrorPct = ref.distanceErrorPct();
            if (distanceErrorPct != null) {
                this.strategy.setDistErrPct(distanceErrorPct.doubleValue());
            }
            this.strategy.setPruneLeafyBranches(false);
        }

        @Override
        public void create(Map<String, Object> value, Consumer<? super IndexableField> addField) {
            Field[] fields;
            Shape shape = GeoJSONUtils.map2Shape(value);
            for (Field field : fields = this.strategy.createIndexableFields(shape)) {
                addField.accept((IndexableField)field);
            }
        }

        private SpatialPrefixTree prefixTree(GeoReference ref) {
            double precisionInMeters = ref.precision() == null ? -1.0 : DistanceUnit.parse(ref.precision(), DistanceUnit.DEFAULT, DistanceUnit.METERS);
            int treeLevels = ref.treeLevels() == null ? 0 : ref.treeLevels();
            return switch (ref.geoTree()) {
                case "geohash" -> new GeohashPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, this.levels(treeLevels, precisionInMeters, Defaults.GEOHASH_LEVELS, true));
                case "legacyquadtree" -> new QuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, this.levels(treeLevels, precisionInMeters, Defaults.QUADTREE_LEVELS, false));
                case "quadtree" -> new PackedQuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, this.levels(treeLevels, precisionInMeters, Defaults.QUADTREE_LEVELS, false));
                default -> throw new IllegalArgumentException("Unknown prefix tree type: " + ref.geoTree());
            };
        }

        private int levels(int treeLevels, double precisionInMeters, int defaultLevels, boolean geoHash) {
            if (treeLevels > 0 || precisionInMeters >= 0.0) {
                int levels = geoHash ? GeoUtils.geoHashLevelsForPrecision(precisionInMeters) : GeoUtils.quadTreeLevelsForPrecision(precisionInMeters);
                return Math.max(treeLevels, precisionInMeters >= 0.0 ? levels : 0);
            }
            return defaultLevels;
        }
    }

    public static final class Defaults {
        public static final int GEOHASH_LEVELS = GeoUtils.geoHashLevelsForPrecision("50m");
        public static final int QUADTREE_LEVELS = GeoUtils.quadTreeLevelsForPrecision("50m");
        public static final double LEGACY_DISTANCE_ERROR_PCT = 0.025;
        public static final double DISTANCE_ERROR_PCT = 0.0;

        private Defaults() {
        }
    }
}

