/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import io.crate.execution.dml.IndexDocumentBuilder;
import io.crate.execution.dml.ValueIndexer;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.SysColumns;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.network.InetAddresses;
import org.jetbrains.annotations.NotNull;

public class IpIndexer
implements ValueIndexer<String> {
    private final Reference ref;
    private final String name;

    public IpIndexer(Reference ref) {
        this.ref = ref;
        this.name = ref.storageIdent();
    }

    @Override
    public void indexValue(@NotNull String value, IndexDocumentBuilder docBuilder) throws IOException {
        InetAddress address = InetAddresses.forString(value);
        if (this.ref.indexType() != IndexType.NONE) {
            docBuilder.addField((IndexableField)new InetAddressPoint(this.name, address));
        }
        if (this.ref.hasDocValues()) {
            docBuilder.addField((IndexableField)new SortedSetDocValuesField(this.name, new BytesRef(InetAddressPoint.encode((InetAddress)address))));
        } else {
            docBuilder.addField((IndexableField)new Field("_field_names", (CharSequence)this.name, (IndexableFieldType)SysColumns.FieldNames.FIELD_TYPE));
        }
        docBuilder.translogWriter().writeValue(value);
    }

    @Override
    public String storageIdentLeafName() {
        return this.ref.storageIdentLeafName();
    }
}

