/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.ShardId;

public abstract class ShardRequest<T extends ShardRequest<T, I>, I extends Item>
extends ReplicationRequest<T>
implements Iterable<I>,
Accountable {
    private final UUID jobId;
    protected List<I> items;

    public ShardRequest(ShardId shardId, UUID jobId) {
        this.setShardId(shardId);
        this.jobId = jobId;
        this.index = shardId.getIndexName();
        this.items = new ArrayList<I>();
    }

    public void add(int location, I item) {
        ((Item)item).location(location);
        this.items.add(item);
    }

    public List<I> items() {
        return this.items;
    }

    @Override
    public Iterator<I> iterator() {
        return Collections.unmodifiableCollection(this.items).iterator();
    }

    public UUID jobId() {
        return this.jobId;
    }

    public ShardRequest(StreamInput in) throws IOException {
        super(in);
        this.jobId = new UUID(in.readLong(), in.readLong());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.jobId.getMostSignificantBits());
        out.writeLong(this.jobId.getLeastSignificantBits());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardRequest that = (ShardRequest)o;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.items, that.items);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.items);
    }

    @Override
    public String toString() {
        return "ShardRequest{, shardId=" + String.valueOf(this.shardId) + ", timeout=" + String.valueOf(this.timeout) + "}";
    }

    protected abstract long shallowSize();

    public long ramBytesUsed() {
        long bytes = this.shallowSize();
        for (Item item : this.items) {
            bytes += item.ramBytesUsed();
        }
        return bytes;
    }

    public static abstract class Item
    implements Writeable,
    Accountable {
        protected final String id;
        protected long version = -3L;
        private int location = -1;
        protected long seqNo = -2L;
        protected long primaryTerm = 0L;

        public Item(String id) {
            this.id = id;
        }

        protected Item(StreamInput in) throws IOException {
            this.id = in.readString();
            this.version = in.readLong();
            this.location = in.readInt();
            this.seqNo = in.readLong();
            this.primaryTerm = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.id);
            out.writeLong(this.version);
            out.writeInt(this.location);
            out.writeLong(this.seqNo);
            out.writeLong(this.primaryTerm);
        }

        public long ramBytesUsed() {
            return RamUsageEstimator.sizeOf((String)this.id) + 8L + 4L + 8L + 8L;
        }

        public String id() {
            return this.id;
        }

        public long version() {
            return this.version;
        }

        public void location(int location) {
            this.location = location;
        }

        public int location() {
            return this.location;
        }

        public long seqNo() {
            return this.seqNo;
        }

        public long primaryTerm() {
            return this.primaryTerm;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)o;
            return this.version == item.version && this.location == item.location && this.seqNo == item.seqNo && this.primaryTerm == item.primaryTerm && Objects.equals(this.id, item.id);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.version, this.location, this.seqNo, this.primaryTerm);
        }

        public String toString() {
            return "Item{id='" + this.id + "', version=" + this.version + ", location=" + this.location + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + "}";
        }
    }
}

