/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dml.upsert;

import io.crate.Streamer;
import io.crate.common.unit.TimeValue;
import io.crate.execution.dml.IndexItem;
import io.crate.execution.dml.ShardRequest;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.Reference;
import io.crate.metadata.settings.SessionSettings;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.jetbrains.annotations.Nullable;

public final class ShardUpsertRequest
extends ShardRequest<ShardUpsertRequest, Item> {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ShardUpsertRequest.class);
    private final DuplicateKeyAction duplicateKeyAction;
    private final boolean continueOnError;
    private boolean isRetry = false;
    private final SessionSettings sessionSettings;
    @Nullable
    private String[] updateColumns;
    @Nullable
    private final Reference[] insertColumns;
    @Nullable
    private Symbol[] returnValues;

    public ShardUpsertRequest(ShardId shardId, UUID jobId, boolean continueOnError, DuplicateKeyAction duplicateKeyAction, SessionSettings sessionSettings, @Nullable String[] updateColumns, @Nullable Reference[] insertColumns, @Nullable Symbol[] returnValues) {
        super(shardId, jobId);
        assert (updateColumns != null || insertColumns != null) : "Missing updateAssignments, whether for update nor for insert";
        this.continueOnError = continueOnError;
        this.duplicateKeyAction = duplicateKeyAction;
        this.sessionSettings = sessionSettings;
        this.updateColumns = updateColumns;
        this.insertColumns = insertColumns;
        this.returnValues = returnValues;
    }

    public ShardUpsertRequest(StreamInput in) throws IOException {
        super(in);
        int returnValuesSize;
        int assignmentsColumnsSize = in.readVInt();
        if (assignmentsColumnsSize > 0) {
            this.updateColumns = new String[assignmentsColumnsSize];
            for (int i = 0; i < assignmentsColumnsSize; ++i) {
                this.updateColumns[i] = in.readString();
            }
        }
        int missingAssignmentsColumnsSize = in.readVInt();
        Streamer<?>[] insertValuesStreamer = null;
        if (missingAssignmentsColumnsSize > 0) {
            this.insertColumns = new Reference[missingAssignmentsColumnsSize];
            for (int i = 0; i < missingAssignmentsColumnsSize; ++i) {
                this.insertColumns[i] = Reference.fromStream(in);
            }
            insertValuesStreamer = Symbols.streamerArray(this.insertColumns);
        } else {
            this.insertColumns = null;
        }
        this.continueOnError = in.readBoolean();
        this.duplicateKeyAction = DuplicateKeyAction.values()[in.readVInt()];
        if (in.getVersion().before(Version.V_5_5_0)) {
            in.readBoolean();
        }
        this.sessionSettings = new SessionSettings(in);
        int numItems = in.readVInt();
        this.items = new ArrayList(numItems);
        for (int i = 0; i < numItems; ++i) {
            this.items.add(new Item(in, insertValuesStreamer));
        }
        if (in.getVersion().onOrAfter(Version.V_4_2_0) && (returnValuesSize = in.readVInt()) > 0) {
            this.returnValues = new Symbol[returnValuesSize];
            for (int i = 0; i < returnValuesSize; ++i) {
                this.returnValues[i] = Symbol.fromStream(in);
            }
        }
        this.isRetry = in.getVersion().onOrAfter(Version.V_4_8_0) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.updateColumns != null) {
            out.writeVInt(this.updateColumns.length);
            for (String column : this.updateColumns) {
                out.writeString(column);
            }
        } else {
            out.writeVInt(0);
        }
        Streamer[] insertValuesStreamer = null;
        if (this.insertColumns != null) {
            out.writeVInt(this.insertColumns.length);
            for (Reference reference : this.insertColumns) {
                Reference.toStream(out, reference);
            }
            insertValuesStreamer = Symbols.streamerArray(this.insertColumns);
        } else {
            out.writeVInt(0);
        }
        out.writeBoolean(this.continueOnError);
        out.writeVInt(this.duplicateKeyAction.ordinal());
        if (out.getVersion().before(Version.V_5_5_0)) {
            out.writeBoolean(true);
        }
        this.sessionSettings.writeTo(out);
        out.writeVInt(this.items.size());
        for (Item item : this.items) {
            item.writeTo(out, insertValuesStreamer);
        }
        if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
            if (this.returnValues != null) {
                out.writeVInt(this.returnValues.length);
                for (Symbol returnValue : this.returnValues) {
                    Symbol.toStream(returnValue, out);
                }
            } else {
                out.writeVInt(0);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_4_8_0)) {
            out.writeBoolean(this.isRetry);
        }
    }

    @Override
    public void onRetry() {
        this.isRetry = true;
    }

    public boolean isRetry() {
        return this.isRetry;
    }

    @Nullable
    public SessionSettings sessionSettings() {
        return this.sessionSettings;
    }

    @Nullable
    public Symbol[] returnValues() {
        return this.returnValues;
    }

    @Nullable
    public String[] updateColumns() {
        return this.updateColumns;
    }

    @Nullable
    public Reference[] insertColumns() {
        return this.insertColumns;
    }

    public boolean continueOnError() {
        return this.continueOnError;
    }

    public DuplicateKeyAction duplicateKeyAction() {
        return this.duplicateKeyAction;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ShardUpsertRequest items = (ShardUpsertRequest)o;
        return this.continueOnError == items.continueOnError && Objects.equals(this.sessionSettings, items.sessionSettings) && this.duplicateKeyAction == items.duplicateKeyAction && Arrays.equals(this.updateColumns, items.updateColumns) && Arrays.equals(this.insertColumns, items.insertColumns) && Arrays.equals(this.returnValues, items.returnValues);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(new Object[]{super.hashCode(), this.sessionSettings, this.duplicateKeyAction, this.continueOnError});
        result = 31 * result + Arrays.hashCode(this.updateColumns);
        result = 31 * result + Arrays.hashCode(this.insertColumns);
        result = 31 * result + Arrays.hashCode(this.returnValues);
        return result;
    }

    @Override
    protected long shallowSize() {
        return SHALLOW_SIZE;
    }

    public static enum DuplicateKeyAction {
        UPDATE_OR_FAIL,
        OVERWRITE,
        IGNORE;

    }

    public static final class Item
    extends ShardRequest.Item
    implements IndexItem {
        public static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Item.class);
        @Nullable
        private Symbol[] updateAssignments;
        @Nullable
        private Object[] insertValues;
        private List<String> pkValues;
        private final long autoGeneratedTimestamp;
        private final long usedBytes;

        public static Item forUpdate(String id, Symbol[] assignments, long requiredVersion, long seqNo, long primaryTerm, long fullDocSizeEstimate) {
            long usedBytes = SHALLOW_SIZE;
            usedBytes += fullDocSizeEstimate;
            usedBytes += RamUsageEstimator.sizeOf((String)id);
            for (Symbol assignment : assignments) {
                usedBytes += assignment.ramBytesUsed();
            }
            return new Item(id, assignments, null, requiredVersion, seqNo, primaryTerm, List.of(), -1L, usedBytes);
        }

        public static Item forInsert(String id, List<String> pkValues, long autoGeneratedTimestamp, @Nullable Reference[] insertColumns, @Nullable Object[] values, @Nullable Symbol[] onConflictAssignments, long fullDocSizeEstimate) {
            long usedBytes = SHALLOW_SIZE;
            usedBytes += RamUsageEstimator.sizeOf((String)id);
            for (String pkValue : pkValues) {
                usedBytes += RamUsageEstimator.sizeOf((String)pkValue);
            }
            if (values != null) {
                assert (insertColumns != null) : "If insertValues are present, insertColumns must be present too";
                for (int i = 0; i < values.length; ++i) {
                    DataType<?> valueType = insertColumns[i].valueType();
                    usedBytes += valueType.valueBytes(values[i]);
                }
            }
            if (onConflictAssignments != null) {
                usedBytes += fullDocSizeEstimate;
                for (Symbol assignment : onConflictAssignments) {
                    usedBytes += assignment.ramBytesUsed();
                }
            }
            return new Item(id, onConflictAssignments, values, -3L, -2L, 0L, pkValues, autoGeneratedTimestamp, usedBytes);
        }

        Item(String id, @Nullable Symbol[] updateAssignments, @Nullable Object[] insertValues, long version, long seqNo, long primaryTerm, List<String> pkValues, long autoGeneratedTimestamp, long usedBytes) {
            super(id);
            this.updateAssignments = updateAssignments;
            this.version = version;
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.insertValues = insertValues;
            this.pkValues = pkValues;
            this.autoGeneratedTimestamp = autoGeneratedTimestamp;
            this.usedBytes = usedBytes;
        }

        @Override
        public long ramBytesUsed() {
            return this.usedBytes;
        }

        @Nullable
        Symbol[] updateAssignments() {
            return this.updateAssignments;
        }

        @Override
        @Nullable
        public Object[] insertValues() {
            return this.insertValues;
        }

        public void insertValues(Object[] insertValues) {
            this.insertValues = insertValues;
        }

        @Override
        public List<String> pkValues() {
            return this.pkValues;
        }

        public void pkValues(List<String> pkValues) {
            this.pkValues = pkValues;
        }

        public long autoGeneratedTimestamp() {
            return this.autoGeneratedTimestamp;
        }

        private static boolean streamPkValues(Version version) {
            return version.after(Version.V_4_7_2) && !version.equals(Version.V_4_8_0);
        }

        public Item(StreamInput in, @Nullable Streamer<?>[] insertValueStreamers) throws IOException {
            super(in);
            int missingAssignmentsSize;
            int i;
            if (in.readBoolean()) {
                int assignmentsSize = in.readVInt();
                this.updateAssignments = new Symbol[assignmentsSize];
                for (i = 0; i < assignmentsSize; ++i) {
                    this.updateAssignments[i] = Symbol.fromStream(in);
                }
            }
            if ((missingAssignmentsSize = in.readVInt()) > 0) {
                assert (insertValueStreamers != null) : "streamers are required if reading insert values";
                this.insertValues = new Object[missingAssignmentsSize];
                for (i = 0; i < missingAssignmentsSize; ++i) {
                    this.insertValues[i] = insertValueStreamers[i].readValueFrom(in);
                }
            }
            if (in.getVersion().before(Version.V_5_8_0)) {
                if (in.readBoolean()) {
                    throw new IllegalArgumentException("Cannot handle upsert request from a node running version " + String.valueOf(in.getVersion()));
                }
                if (in.getVersion().before(Version.V_5_3_0)) {
                    this.seqNo = -3L;
                }
            }
            this.pkValues = Item.streamPkValues(in.getVersion()) ? in.readList(StreamInput::readString) : List.of();
            this.autoGeneratedTimestamp = in.getVersion().onOrAfter(Version.V_5_0_0) ? in.readLong() : -1L;
            this.usedBytes = in.getVersion().after(Version.V_5_10_10) ? in.readLong() : 0L;
        }

        public void writeTo(StreamOutput out, @Nullable Streamer[] insertValueStreamers) throws IOException {
            super.writeTo(out);
            if (this.updateAssignments != null) {
                out.writeBoolean(true);
                out.writeVInt(this.updateAssignments.length);
                for (Symbol updateAssignment : this.updateAssignments) {
                    Symbol.toStream(updateAssignment, out);
                }
            } else {
                out.writeBoolean(false);
            }
            if (this.insertValues != null) {
                assert (insertValueStreamers != null && insertValueStreamers.length >= this.insertValues.length) : "streamers are required to stream insert values and must have a streamer for each value";
                out.writeVInt(this.insertValues.length);
                for (int i = 0; i < this.insertValues.length; ++i) {
                    insertValueStreamers[i].writeValueTo(out, this.insertValues[i]);
                }
            } else {
                out.writeVInt(0);
            }
            if (out.getVersion().before(Version.V_5_8_0)) {
                out.writeBoolean(false);
            }
            if (Item.streamPkValues(out.getVersion())) {
                out.writeStringCollection(this.pkValues);
            }
            if (out.getVersion().onOrAfter(Version.V_5_0_0)) {
                out.writeLong(this.autoGeneratedTimestamp);
            }
            if (out.getVersion().after(Version.V_5_10_10)) {
                out.writeLong(this.usedBytes);
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Item item = (Item)o;
            return Arrays.equals(this.updateAssignments, item.updateAssignments) && Arrays.equals(this.insertValues, item.insertValues);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + Arrays.hashCode(this.updateAssignments);
            result = 31 * result + Arrays.hashCode(this.insertValues);
            return result;
        }
    }

    public static class Builder {
        private final SessionSettings sessionSettings;
        private final TimeValue timeout;
        private final DuplicateKeyAction duplicateKeyAction;
        private final boolean continueOnError;
        @Nullable
        private final String[] assignmentsColumns;
        @Nullable
        private final Reference[] missingAssignmentsColumns;
        private final UUID jobId;
        @Nullable
        private final Symbol[] returnValues;

        public Builder(SessionSettings sessionSettings, TimeValue timeout, DuplicateKeyAction duplicateKeyAction, boolean continueOnError, @Nullable String[] assignmentsColumns, @Nullable Reference[] missingAssignmentsColumns, @Nullable Symbol[] returnValue, UUID jobId) {
            this.sessionSettings = sessionSettings;
            this.timeout = timeout;
            this.duplicateKeyAction = duplicateKeyAction;
            this.continueOnError = continueOnError;
            this.assignmentsColumns = assignmentsColumns;
            this.missingAssignmentsColumns = missingAssignmentsColumns;
            this.jobId = jobId;
            this.returnValues = returnValue;
        }

        public ShardUpsertRequest newRequest(ShardId shardId) {
            return (ShardUpsertRequest)new ShardUpsertRequest(shardId, this.jobId, this.continueOnError, this.duplicateKeyAction, this.sessionSettings, this.assignmentsColumns, this.missingAssignmentsColumns, this.returnValues).timeout(this.timeout);
        }
    }
}

