/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.phases;

import io.crate.Streamer;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProjectionsPhase
implements ExecutionPhase {
    private final UUID jobId;
    private final int executionPhaseId;
    private final String name;
    protected final List<Projection> projections;
    protected List<DataType<?>> outputTypes = List.of();

    protected AbstractProjectionsPhase(UUID jobId, int executionPhaseId, String name, @Nullable Collection<? extends Projection> projections) {
        this.jobId = jobId;
        this.executionPhaseId = executionPhaseId;
        this.name = name;
        this.projections = projections == null ? new ArrayList<Projection>() : new ArrayList<Projection>(projections);
    }

    protected static List<DataType<?>> extractOutputTypes(List<Symbol> outputs, List<Projection> projections) {
        if (projections.isEmpty()) {
            return Symbols.typeView(outputs);
        }
        Projection lastProjection = projections.get(projections.size() - 1);
        return Symbols.typeView(lastProjection.outputs());
    }

    @Override
    public String name() {
        return this.name;
    }

    public UUID jobId() {
        return this.jobId;
    }

    @Override
    public int phaseId() {
        return this.executionPhaseId;
    }

    @Override
    public Streamer<?>[] getStreamers() {
        return DataTypes.getStreamers(this.outputTypes());
    }

    public boolean hasProjections() {
        return this.projections.size() > 0;
    }

    public List<Projection> projections() {
        return this.projections;
    }

    public void addProjection(Projection projection) {
        this.projections.add(projection);
        this.outputTypes = Symbols.typeView(projection.outputs());
    }

    public Optional<Projection> finalProjection() {
        if (this.projections.size() == 0) {
            return Optional.empty();
        }
        return Optional.of(this.projections.get(this.projections.size() - 1));
    }

    public List<DataType<?>> outputTypes() {
        return this.outputTypes;
    }

    protected AbstractProjectionsPhase(StreamInput in) throws IOException {
        int numProjections;
        this.name = in.readString();
        this.jobId = new UUID(in.readLong(), in.readLong());
        this.executionPhaseId = in.readVInt();
        int numCols = in.readVInt();
        if (numCols > 0) {
            this.outputTypes = new ArrayList(numCols);
            for (int i = 0; i < numCols; ++i) {
                this.outputTypes.add(DataTypes.fromStream(in));
            }
        }
        if ((numProjections = in.readVInt()) > 0) {
            this.projections = new ArrayList<Projection>(numProjections);
            for (int i = 0; i < numProjections; ++i) {
                this.projections.add(Projection.fromStream(in));
            }
        } else {
            this.projections = List.of();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        assert (this.jobId != null) : "jobId must not be null";
        out.writeLong(this.jobId.getMostSignificantBits());
        out.writeLong(this.jobId.getLeastSignificantBits());
        out.writeVInt(this.executionPhaseId);
        int numCols = this.outputTypes.size();
        out.writeVInt(numCols);
        for (int i = 0; i < numCols; ++i) {
            DataTypes.toStream(this.outputTypes.get(i), out);
        }
        if (this.hasProjections()) {
            out.writeVInt(this.projections.size());
            for (Projection p : this.projections) {
                Projection.toStream(p, out);
            }
        } else {
            out.writeVInt(0);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractProjectionsPhase node = (AbstractProjectionsPhase)o;
        return !(this.name == null ? node.name != null : !this.name.equals(node.name));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "AbstractProjectionsPhase{name=" + this.name + ", projections=" + String.valueOf(this.projections) + ", outputTypes=" + String.valueOf(this.outputTypes) + "}";
    }
}

