/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.analyze.CopyStatementSettings;
import io.crate.execution.dsl.projection.AbstractIndexWriterProjection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class SourceIndexWriterProjection
extends AbstractIndexWriterProjection {
    private final boolean failFast;
    private final Boolean overwriteDuplicates;
    private final Reference rawSourceReference;
    private final InputColumn rawSourceSymbol;
    private final List<? extends Symbol> outputs;
    @Nullable
    private final String[] excludes;

    public SourceIndexWriterProjection(RelationName relationName, @Nullable String partitionIdent, Reference rawSourceReference, InputColumn rawSourcePtr, List<ColumnIdent> primaryKeys, List<Symbol> partitionedBySymbols, @Nullable ColumnIdent clusteredByColumn, Settings settings, @Nullable String[] excludes, List<Symbol> idSymbols, @Nullable Symbol clusteredBySymbol, List<? extends Symbol> outputs, boolean autoCreateIndices) {
        super(relationName, partitionIdent, primaryKeys, clusteredByColumn, settings, idSymbols, autoCreateIndices);
        this.rawSourceReference = rawSourceReference;
        this.excludes = excludes;
        this.partitionedBySymbols = partitionedBySymbols;
        this.clusteredBySymbol = clusteredBySymbol;
        this.rawSourceSymbol = rawSourcePtr;
        this.outputs = outputs;
        this.overwriteDuplicates = CopyStatementSettings.OVERWRITE_DUPLICATES_SETTING.get(settings);
        this.failFast = CopyStatementSettings.FAIL_FAST_SETTING.get(settings);
    }

    SourceIndexWriterProjection(StreamInput in) throws IOException {
        super(in);
        int i;
        int length;
        Version version = in.getVersion();
        this.failFast = version.onOrAfter(Version.V_4_7_0) ? in.readBoolean() : false;
        this.overwriteDuplicates = in.readBoolean();
        this.rawSourceReference = Reference.fromStream(in);
        this.rawSourceSymbol = (InputColumn)Symbol.fromStream(in);
        if (version.before(Version.V_5_3_0) && in.readBoolean()) {
            length = in.readVInt();
            for (i = 0; i < length; ++i) {
                in.readString();
            }
        }
        if (in.readBoolean()) {
            length = in.readVInt();
            this.excludes = new String[length];
            for (i = 0; i < length; ++i) {
                this.excludes[i] = in.readString();
            }
        } else {
            this.excludes = null;
        }
        this.outputs = Symbols.fromStream(in);
        if (version.onOrAfter(Version.V_4_8_0) && version.before(Version.V_5_5_0)) {
            in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Version version = out.getVersion();
        if (version.onOrAfter(Version.V_4_7_0)) {
            out.writeBoolean(this.failFast);
        }
        out.writeBoolean(this.overwriteDuplicates);
        Reference.toStream(out, this.rawSourceReference);
        Symbol.toStream(this.rawSourceSymbol, out);
        if (version.before(Version.V_5_3_0)) {
            out.writeBoolean(false);
        }
        if (this.excludes == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.excludes.length);
            for (String exclude : this.excludes) {
                out.writeString(exclude);
            }
        }
        Symbols.toStream(this.outputs, out);
        if (version.onOrAfter(Version.V_4_8_0) && version.before(Version.V_5_5_0)) {
            out.writeBoolean(true);
        }
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitSourceIndexWriterProjection(this, context);
    }

    public InputColumn rawSource() {
        return this.rawSourceSymbol;
    }

    public Reference rawSourceReference() {
        return this.rawSourceReference;
    }

    @Nullable
    public String[] excludes() {
        return this.excludes;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.INDEX_WRITER;
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SourceIndexWriterProjection that = (SourceIndexWriterProjection)o;
        return Objects.equals(this.overwriteDuplicates, that.overwriteDuplicates) && Objects.equals(this.rawSourceReference, that.rawSourceReference) && Objects.equals(this.rawSourceSymbol, that.rawSourceSymbol) && Arrays.equals(this.excludes, that.excludes) && this.failFast == that.failFast;
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.overwriteDuplicates, this.rawSourceReference, this.rawSourceSymbol, this.failFast);
        result = 31 * result + Arrays.hashCode(this.excludes);
        return result;
    }

    public boolean overwriteDuplicates() {
        return this.overwriteDuplicates;
    }

    public boolean failFast() {
        return this.failFast;
    }
}

