/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.analyze.WindowDefinition;
import io.crate.common.collections.Lists;
import io.crate.common.collections.MapBuilder;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.WindowFunction;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class WindowAggProjection
extends Projection {
    private final WindowDefinition windowDefinition;
    private final List<Symbol> standaloneWithInputs;
    private final ArrayList<Symbol> outputs;
    private final List<WindowFunction> windowFunctions;

    public WindowAggProjection(WindowDefinition windowDefinition, List<WindowFunction> windowFunctions, List<Symbol> standaloneWithInputs) {
        this.windowFunctions = windowFunctions;
        assert (windowFunctions.stream().noneMatch(Symbol.IS_COLUMN)) : "Cannot operate on Reference or Field: " + String.valueOf(windowFunctions);
        assert (standaloneWithInputs.stream().noneMatch(Symbol.IS_COLUMN)) : "Cannot operate on Reference or Field: " + String.valueOf(standaloneWithInputs);
        this.windowDefinition = windowDefinition;
        this.standaloneWithInputs = standaloneWithInputs;
        this.outputs = new ArrayList<Symbol>(standaloneWithInputs);
        this.outputs.addAll(windowFunctions);
    }

    WindowAggProjection(StreamInput in) throws IOException {
        this.windowDefinition = new WindowDefinition(in);
        this.standaloneWithInputs = Symbols.fromStream(in);
        Version version = in.getVersion();
        if (version.onOrAfter(Version.V_4_2_1)) {
            this.windowFunctions = Symbols.fromStream(in);
        } else {
            boolean onOrAfter4_1_0 = version.onOrAfter(Version.V_4_1_0);
            int functionsCount = in.readVInt();
            this.windowFunctions = new ArrayList<WindowFunction>();
            for (int i = 0; i < functionsCount; ++i) {
                WindowFunction function = (WindowFunction)Symbol.fromStream(in);
                if (onOrAfter4_1_0) {
                    Symbols.fromStream(in);
                }
                Symbols.fromStream(in);
                this.windowFunctions.add(function);
            }
        }
        this.outputs = new ArrayList<Symbol>(this.standaloneWithInputs);
        this.outputs.addAll(this.windowFunctions);
    }

    public WindowDefinition windowDefinition() {
        return this.windowDefinition;
    }

    public List<WindowFunction> windowFunctions() {
        return this.windowFunctions;
    }

    public List<Symbol> standalone() {
        return this.standaloneWithInputs;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowAggProjection that = (WindowAggProjection)o;
        return Objects.equals(this.windowDefinition, that.windowDefinition) && Objects.equals(this.windowFunctions, that.windowFunctions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.windowDefinition, this.windowFunctions);
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.WINDOW_AGGREGATION;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitWindowAgg(this, context);
    }

    @Override
    public List<? extends Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.windowDefinition.writeTo(out);
        Symbols.toStream(this.standaloneWithInputs, out);
        Version version = out.getVersion();
        if (version.onOrAfter(Version.V_4_2_1)) {
            Symbols.toStream(this.windowFunctions, out);
        } else {
            boolean onOrAfter4_1_0 = version.onOrAfter(Version.V_4_1_0);
            out.writeVInt(this.windowFunctions.size());
            for (WindowFunction windowFunction : this.windowFunctions) {
                Symbol.toStream(windowFunction, out);
                if (onOrAfter4_1_0) {
                    Symbol filter = windowFunction.filter();
                    Symbol.toStream(filter == null ? Literal.BOOLEAN_TRUE : filter, out);
                }
                Symbols.toStream(windowFunction.arguments(), out);
            }
        }
    }

    @Override
    public Map<String, Object> mapRepresentation() {
        return MapBuilder.newMapBuilder().put((Object)"type", (Object)"WindowAggregation").put((Object)"windowFunctions", (Object)Lists.joinOn((String)", ", this.windowFunctions, (Function<WindowFunction, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/WindowFunction;)Ljava/lang/String;)())).map();
    }
}

