/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.dsl.projection;

import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.ProjectionType;
import io.crate.execution.dsl.projection.ProjectionVisitor;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.TransactionContext;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;

public class WriterProjection
extends Projection {
    private static final List<Symbol> OUTPUTS = List.of(new InputColumn(0, DataTypes.LONG));
    private final Symbol uri;
    private final List<Symbol> inputs;
    @Nullable
    private final List<String> outputNames;
    private final Map<ColumnIdent, Symbol> overwrites;
    private final Settings withClauseOptions;
    private final OutputFormat outputFormat;
    private final CompressionType compressionType;

    public WriterProjection(List<Symbol> inputs, Symbol uri, @Nullable CompressionType compressionType, Map<ColumnIdent, Symbol> overwrites, @Nullable List<String> outputNames, OutputFormat outputFormat, Settings withClauseOptions) {
        this.inputs = inputs;
        this.uri = uri;
        this.overwrites = overwrites;
        this.outputNames = outputNames;
        this.outputFormat = outputFormat;
        this.compressionType = compressionType;
        this.withClauseOptions = withClauseOptions;
    }

    public WriterProjection(StreamInput in) throws IOException {
        this.uri = Symbol.fromStream(in);
        int size = in.readVInt();
        if (size > 0) {
            this.outputNames = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                this.outputNames.add(in.readString());
            }
        } else {
            this.outputNames = null;
        }
        this.inputs = Symbols.fromStream(in);
        int numOverwrites = in.readVInt();
        this.overwrites = new HashMap<ColumnIdent, Symbol>(numOverwrites);
        for (int i = 0; i < numOverwrites; ++i) {
            this.overwrites.put(ColumnIdent.of(in), Symbol.fromStream(in));
        }
        int compressionTypeOrdinal = in.readInt();
        this.compressionType = compressionTypeOrdinal >= 0 ? CompressionType.values()[compressionTypeOrdinal] : null;
        this.outputFormat = OutputFormat.values()[in.readInt()];
        this.withClauseOptions = in.getVersion().onOrAfter(Version.V_4_8_0) ? Settings.readSettingsFromStream(in) : Settings.EMPTY;
    }

    @Override
    public RowGranularity requiredGranularity() {
        return RowGranularity.SHARD;
    }

    public Symbol uri() {
        return this.uri;
    }

    public List<Symbol> outputs() {
        return OUTPUTS;
    }

    public List<Symbol> inputs() {
        return this.inputs;
    }

    @Override
    public ProjectionType projectionType() {
        return ProjectionType.WRITER;
    }

    public Map<ColumnIdent, Symbol> overwrites() {
        return this.overwrites;
    }

    public List<String> outputNames() {
        return this.outputNames;
    }

    public OutputFormat outputFormat() {
        return this.outputFormat;
    }

    public CompressionType compressionType() {
        return this.compressionType;
    }

    @Override
    public <C, R> R accept(ProjectionVisitor<C, R> visitor, C context) {
        return visitor.visitWriterProjection(this, context);
    }

    public Settings withClauseOptions() {
        return this.withClauseOptions;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        Symbol.toStream(this.uri, out);
        if (this.outputNames != null) {
            out.writeVInt(this.outputNames.size());
            for (String string : this.outputNames) {
                out.writeString(string);
            }
        } else {
            out.writeVInt(0);
        }
        Symbols.toStream(this.inputs, out);
        out.writeVInt(this.overwrites.size());
        for (Map.Entry entry : this.overwrites.entrySet()) {
            ((ColumnIdent)entry.getKey()).writeTo(out);
            Symbol.toStream((Symbol)entry.getValue(), out);
        }
        out.writeInt(this.compressionType != null ? this.compressionType.ordinal() : -1);
        out.writeInt(this.outputFormat.ordinal());
        if (out.getVersion().onOrAfter(Version.V_4_8_0)) {
            Settings.writeSettingsToStream(out, this.withClauseOptions);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriterProjection that = (WriterProjection)o;
        if (!Objects.equals(this.outputNames, that.outputNames)) {
            return false;
        }
        if (!this.uri.equals(that.uri)) {
            return false;
        }
        if (!this.overwrites.equals(that.overwrites)) {
            return false;
        }
        if (!Objects.equals((Object)this.compressionType, (Object)that.compressionType)) {
            return false;
        }
        if (!this.outputFormat.equals((Object)that.outputFormat)) {
            return false;
        }
        return Objects.equals(this.withClauseOptions, that.withClauseOptions);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.uri.hashCode();
        result = 31 * result + (this.outputNames != null ? this.outputNames.hashCode() : 0);
        result = 31 * result + this.overwrites.hashCode();
        result = 31 * result + (this.compressionType != null ? this.compressionType.hashCode() : 0);
        result = 31 * result + this.outputFormat.hashCode();
        result = 31 * result + this.withClauseOptions.hashCode();
        return result;
    }

    public String toString() {
        return "WriterProjection{uri=" + String.valueOf(this.uri) + ", outputNames=" + String.valueOf(this.outputNames) + ", compressionType=" + String.valueOf((Object)this.compressionType) + ", outputFormat=" + String.valueOf((Object)this.outputFormat) + ", withClauseOptions{" + this.withClauseOptions.toString() + "}";
    }

    public WriterProjection normalize(EvaluatingNormalizer normalizer, TransactionContext txnCtx) {
        Symbol nUri = normalizer.normalize(this.uri, txnCtx);
        if (this.uri != nUri) {
            return new WriterProjection(this.inputs, this.uri, this.compressionType, this.overwrites, this.outputNames, this.outputFormat, this.withClauseOptions);
        }
        return this;
    }

    public static enum OutputFormat {
        JSON_OBJECT,
        JSON_ARRAY;

    }

    public static enum CompressionType {
        GZIP;

    }
}

