/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.execution.engine.aggregation.impl.CompareByType;
import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.reference.doc.lucene.StoredRowLookup;
import io.crate.expression.symbol.Literal;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.Scalar;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.jetbrains.annotations.Nullable;

public final class CmpByAggregation
extends AggregationFunction<CompareBy, Object> {
    public static final String MAX_BY = "max_by";
    public static final String MIN_BY = "min_by";
    private final Signature signature;
    private final BoundSignature boundSignature;
    private final CompareByType partialType;
    private final int cmpResult;

    public static void register(Functions.Builder builder) {
        TypeSignature returnValueType = TypeSignature.parse("A");
        TypeSignature cmpType = TypeSignature.parse("B");
        TypeVariableConstraint variableConstraintA = TypeVariableConstraint.typeVariableOfAnyType("A");
        TypeVariableConstraint variableConstraintB = TypeVariableConstraint.typeVariableOfAnyType("B");
        builder.add(Signature.builder(MAX_BY, FunctionType.AGGREGATE).argumentTypes(returnValueType, cmpType).returnType(returnValueType).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(variableConstraintA, variableConstraintB).build(), (signature, boundSignature) -> new CmpByAggregation(1, (Signature)signature, (BoundSignature)boundSignature));
        builder.add(Signature.builder(MIN_BY, FunctionType.AGGREGATE).argumentTypes(returnValueType, cmpType).returnType(returnValueType).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(variableConstraintA, variableConstraintB).build(), (signature, boundSignature) -> new CmpByAggregation(-1, (Signature)signature, (BoundSignature)boundSignature));
    }

    public CmpByAggregation(int cmpResult, Signature signature, BoundSignature boundSignature) {
        this.cmpResult = cmpResult;
        this.signature = signature;
        this.boundSignature = boundSignature;
        int size = boundSignature.argTypes().size();
        this.partialType = size == 1 ? (CompareByType)boundSignature.argTypes().get(0) : new CompareByType(boundSignature.argTypes().get(0), boundSignature.argTypes().get(1));
    }

    @Override
    public DocValueAggregator<?> getDocValueAggregator(LuceneReferenceResolver referenceResolver, List<Reference> aggregationReferences, DocTableInfo table, Version shardCreatedVersion, List<Literal<?>> optionalParams) {
        Reference returnField = aggregationReferences.getFirst();
        Reference searchField = aggregationReferences.getLast();
        if (returnField == null) {
            return null;
        }
        if (searchField == null) {
            return null;
        }
        if (!searchField.hasDocValues() || searchField.granularity() != RowGranularity.DOC) {
            return null;
        }
        DataType<?> searchType = searchField.valueType();
        switch (searchType.id()) {
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                Input resultExpression = referenceResolver.getImplementation(returnField);
                if (this.signature.getName().name().equalsIgnoreCase(MIN_BY)) {
                    return new MinByLong(searchField.storageIdent(), searchType, (LuceneCollectorExpression<?>)resultExpression, new CollectorContext(() -> StoredRowLookup.create(shardCreatedVersion, table, referenceResolver.getIndexName())));
                }
                return new MaxByLong(searchField.storageIdent(), searchType, (LuceneCollectorExpression<?>)resultExpression, new CollectorContext(() -> StoredRowLookup.create(shardCreatedVersion, table, referenceResolver.getIndexName())));
            }
        }
        return null;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @Nullable
    public CompareBy newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes(CompareBy.SHALLOW_SIZE);
        return new CompareBy();
    }

    @Override
    public CompareBy iterate(RamAccounting ramAccounting, MemoryManager memoryManager, CompareBy state, Input<?> ... args) throws CircuitBreakingException {
        Object cmpVal = args[1].value();
        if (cmpVal instanceof Comparable) {
            Comparable comparable = (Comparable)cmpVal;
            Comparable<Object> currentValue = state.cmpValue;
            if (currentValue == null || comparable.compareTo(currentValue) == this.cmpResult) {
                state.cmpValue = comparable;
                state.resultValue = args[0].value();
            }
        } else if (cmpVal != null) {
            throw new UnsupportedOperationException("Cannot use `" + this.signature.getName().displayName() + "` on values of type " + this.boundSignature.argTypes().get(1).getName());
        }
        return state;
    }

    @Override
    public CompareBy reduce(RamAccounting ramAccounting, CompareBy state1, CompareBy state2) {
        if (state1.cmpValue == null) {
            return state2;
        }
        if (state2.cmpValue == null) {
            return state1;
        }
        if (state2.cmpValue.compareTo(state1.cmpValue) == this.cmpResult) {
            return state2;
        }
        return state1;
    }

    @Override
    public Object terminatePartial(RamAccounting ramAccounting, CompareBy state) {
        return state.resultValue;
    }

    @Override
    public DataType<?> partialType() {
        return this.partialType;
    }

    static {
        DataTypes.register(1027, CompareByType::new);
    }

    static class MinByLong
    extends CmpByLong {
        public MinByLong(String columnName, DataType<?> searchType, LuceneCollectorExpression<?> resultExpression, CollectorContext collectorContext) {
            super(Long.MAX_VALUE, columnName, searchType, resultExpression, collectorContext);
        }

        @Override
        boolean hasPrecedence(long currentValue, long stateValue) {
            return currentValue < stateValue;
        }
    }

    static class MaxByLong
    extends CmpByLong {
        public MaxByLong(String columnName, DataType<?> searchType, LuceneCollectorExpression<?> resultExpression, CollectorContext collectorContext) {
            super(Long.MIN_VALUE, columnName, searchType, resultExpression, collectorContext);
        }

        @Override
        boolean hasPrecedence(long currentValue, long stateValue) {
            return currentValue > stateValue;
        }
    }

    static class CompareBy {
        static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(CompareBy.class);
        Comparable<Object> cmpValue;
        Object resultValue;

        CompareBy() {
        }

        public int hashCode() {
            return Objects.hash(this.cmpValue, this.resultValue);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompareBy other = (CompareBy)obj;
            return Objects.equals(this.cmpValue, other.cmpValue) && Objects.equals(this.resultValue, other.resultValue);
        }

        public String toString() {
            return "CompareBy{cmpValue=" + String.valueOf(this.cmpValue) + ", resultValue=" + String.valueOf(this.resultValue) + "}";
        }
    }

    static abstract class CmpByLong
    implements DocValueAggregator<CmpByLongState> {
        private final String columnName;
        private final LuceneCollectorExpression<?> resultExpression;
        private final DataType<?> searchType;
        private final long sentinelValue;
        private SortedNumericDocValues values;
        private LeafReaderContext leafReaderContext;

        CmpByLong(long sentinelValue, String columnName, DataType<?> searchType, LuceneCollectorExpression<?> resultExpression, CollectorContext collectorContext) {
            this.sentinelValue = sentinelValue;
            this.columnName = columnName;
            this.searchType = searchType;
            this.resultExpression = resultExpression;
            resultExpression.startCollect(collectorContext);
        }

        @Override
        public CmpByLongState initialState(RamAccounting ramAccounting, MemoryManager memoryManager, Version minNodeVersion) {
            ramAccounting.addBytes(CmpByLongState.SHALLOW_SIZE);
            return new CmpByLongState(this.sentinelValue);
        }

        @Override
        public void loadDocValues(LeafReaderContext leafReaderContext) throws IOException {
            this.leafReaderContext = leafReaderContext;
            this.values = DocValues.getSortedNumeric((LeafReader)leafReaderContext.reader(), (String)this.columnName);
        }

        abstract boolean hasPrecedence(long var1, long var3);

        @Override
        public void apply(RamAccounting ramAccounting, int doc, CmpByLongState state) throws IOException {
            long value;
            if (this.values.advanceExact(doc) && this.values.docValueCount() == 1 && this.hasPrecedence(value = this.values.nextValue(), state.cmpValue)) {
                state.hasValue = true;
                state.cmpValue = value;
                state.docId = doc;
                state.leafReaderContext = this.leafReaderContext;
            }
        }

        @Override
        public Object partialResult(RamAccounting ramAccounting, CmpByLongState state) {
            CompareBy compareBy = new CompareBy();
            if (state.hasValue) {
                compareBy.cmpValue = (Comparable)this.searchType.sanitizeValue(state.cmpValue);
                try {
                    this.resultExpression.setNextReader(new ReaderContext(state.leafReaderContext));
                    this.resultExpression.setNextDocId(state.docId);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                compareBy.resultValue = this.resultExpression.value();
            }
            return compareBy;
        }
    }

    static class CmpByLongState {
        static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(CmpByLongState.class);
        long cmpValue;
        int docId;
        LeafReaderContext leafReaderContext;
        boolean hasValue = false;

        public CmpByLongState(long cmpValue) {
            this.cmpValue = cmpValue;
        }
    }
}

