/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl;

import io.crate.data.Input;
import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.memory.MemoryManager;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import org.elasticsearch.Version;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class IntervalSumAggregation
extends AggregationFunction<Period, Period> {
    public static final String NAME = "sum";
    private final Signature signature;
    private final BoundSignature boundSignature;
    private final int bytesSize;

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.AGGREGATE).argumentTypes(DataTypes.INTERVAL.getTypeSignature()).returnType(DataTypes.INTERVAL.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), IntervalSumAggregation::new);
    }

    @VisibleForTesting
    private IntervalSumAggregation(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.bytesSize = DataTypes.INTERVAL.fixedSize();
    }

    @Override
    @Nullable
    public Period newState(RamAccounting ramAccounting, Version indexVersionCreated, Version minNodeInCluster, MemoryManager memoryManager) {
        ramAccounting.addBytes((long)this.bytesSize);
        return null;
    }

    @Override
    public Period iterate(RamAccounting ramAccounting, MemoryManager memoryManager, Period state, Input<?> ... args) throws CircuitBreakingException {
        return this.reduce(ramAccounting, state, DataTypes.INTERVAL.sanitizeValue(args[0].value()));
    }

    @Override
    public Period reduce(RamAccounting ramAccounting, Period state1, Period state2) {
        if (state1 == null) {
            return state2;
        }
        if (state2 == null) {
            return state1;
        }
        return state1.plus((ReadablePeriod)state2);
    }

    @Override
    public Period terminatePartial(RamAccounting ramAccounting, Period state) {
        return state;
    }

    @Override
    public DataType<?> partialType() {
        return this.boundSignature.returnType();
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public boolean isRemovableCumulative() {
        return true;
    }

    @Override
    public Period removeFromAggregatedState(RamAccounting ramAccounting, Period previousAggState, Input<?>[] stateToRemove) {
        return previousAggState.minus((ReadablePeriod)DataTypes.INTERVAL.sanitizeValue(stateToRemove[0].value()));
    }
}

