/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.aggregation.impl.templates;

import io.crate.data.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.DocValueAggregator;
import io.crate.memory.MemoryManager;
import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.Version;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.TriFunction;
import org.jetbrains.annotations.Nullable;

public class SortedNumericDocValueAggregator<T>
implements DocValueAggregator<T> {
    private final String columnName;
    private final TriFunction<RamAccounting, MemoryManager, Version, T> stateInitializer;
    private final CheckedBiConsumer<SortedNumericDocValues, T, IOException> docValuesConsumer;
    private SortedNumericDocValues values;

    public SortedNumericDocValueAggregator(String columnName, TriFunction<RamAccounting, MemoryManager, Version, T> stateInitializer, CheckedBiConsumer<SortedNumericDocValues, T, IOException> docValuesConsumer) {
        this.columnName = columnName;
        this.stateInitializer = stateInitializer;
        this.docValuesConsumer = docValuesConsumer;
    }

    @Override
    public T initialState(RamAccounting ramAccounting, MemoryManager memoryManager, Version version) {
        return this.stateInitializer.apply(ramAccounting, memoryManager, version);
    }

    @Override
    public void loadDocValues(LeafReaderContext reader) throws IOException {
        this.values = DocValues.getSortedNumeric((LeafReader)reader.reader(), (String)this.columnName);
    }

    @Override
    public void apply(RamAccounting ramAccounting, int doc, T state) throws IOException {
        if (this.values.advanceExact(doc) && this.values.docValueCount() == 1) {
            this.docValuesConsumer.accept(this.values, (SortedNumericDocValues)state);
        }
    }

    @Override
    @Nullable
    public Object partialResult(RamAccounting ramAccounting, T state) {
        return state;
    }
}

