/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect;

import io.crate.common.collections.RefCountedItem;
import io.crate.data.BatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.SentinelRow;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.engine.collect.CollectTask;
import io.crate.execution.engine.collect.DocInputFactory;
import io.crate.execution.engine.collect.DocValuesAggregates;
import io.crate.execution.engine.collect.DocValuesGroupByOptimizedIterator;
import io.crate.execution.engine.collect.GroupByOptimizedIterator;
import io.crate.execution.engine.collect.ShardCollectorProvider;
import io.crate.execution.engine.collect.collectors.LuceneBatchIterator;
import io.crate.execution.engine.collect.collectors.LuceneOrderedDocCollector;
import io.crate.execution.engine.collect.collectors.OptimizeQueryForSearchAfter;
import io.crate.execution.engine.collect.collectors.OrderedDocCollector;
import io.crate.execution.engine.export.FileOutputFactory;
import io.crate.execution.engine.sort.LuceneSort;
import io.crate.execution.jobs.NodeLimits;
import io.crate.execution.jobs.SharedShardContext;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.LuceneReferenceResolver;
import io.crate.expression.reference.doc.lucene.StoredRowLookup;
import io.crate.expression.reference.sys.shard.ShardRowContext;
import io.crate.expression.symbol.Symbols;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.Version;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;

public class LuceneShardCollectorProvider
extends ShardCollectorProvider {
    private static final Logger LOGGER = LogManager.getLogger(LuceneShardCollectorProvider.class);
    private final Supplier<String> localNodeId;
    private final LuceneQueryBuilder luceneQueryBuilder;
    private final NodeContext nodeCtx;
    private final DocInputFactory docInputFactory;
    private final BigArrays bigArrays;
    private final RelationName relationName;
    private final LuceneReferenceResolver referenceResolver;

    public LuceneShardCollectorProvider(LuceneQueryBuilder luceneQueryBuilder, ClusterService clusterService, NodeLimits nodeJobsCounter, CircuitBreakerService circuitBreakerService, NodeContext nodeCtx, ThreadPool threadPool, Settings settings, ElasticsearchClient elasticsearchClient, IndexShard indexShard, BigArrays bigArrays, Map<String, FileOutputFactory> fileOutputFactoryMap) {
        super(clusterService, circuitBreakerService, nodeJobsCounter, nodeCtx, threadPool, settings, elasticsearchClient, indexShard, new ShardRowContext(indexShard, clusterService), fileOutputFactoryMap);
        this.luceneQueryBuilder = luceneQueryBuilder;
        this.nodeCtx = nodeCtx;
        this.localNodeId = () -> clusterService.localNode().getId();
        this.relationName = RelationName.fromIndexName(indexShard.shardId().getIndexName());
        DocTableInfo table = (DocTableInfo)nodeCtx.schemas().getTableInfo(this.relationName);
        this.referenceResolver = new LuceneReferenceResolver(indexShard.shardId().getIndexName(), table.partitionedByColumns(), table.isParentReferenceIgnored());
        this.docInputFactory = new DocInputFactory(nodeCtx, this.referenceResolver);
        this.bigArrays = bigArrays;
    }

    @Override
    protected BatchIterator<Row> getUnorderedIterator(RoutedCollectPhase collectPhase, boolean requiresScroll, CollectTask collectTask) {
        ShardId shardId = this.indexShard.shardId();
        SharedShardContext sharedShardContext = collectTask.sharedShardContexts().getOrCreateContext(shardId);
        RefCountedItem<? extends IndexSearcher> searcher = sharedShardContext.acquireSearcher("unordered-iterator: " + LuceneShardCollectorProvider.formatSource(collectPhase));
        collectTask.addSearcher(sharedShardContext.readerId(), searcher);
        if (this.indexShard.isClosed()) {
            return InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL);
        }
        IndexService indexService = sharedShardContext.indexService();
        DocTableInfo table = (DocTableInfo)this.nodeCtx.schemas().getTableInfo(this.relationName);
        Version shardCreatedVersion = this.indexShard.getVersionCreated();
        LuceneQueryBuilder.Context queryContext = this.luceneQueryBuilder.convert(collectPhase.where(), collectTask.txnCtx(), this.indexShard.shardId().getIndexName(), indexService.indexAnalyzers(), table, shardCreatedVersion, indexService.cache());
        InputFactory.Context<LuceneCollectorExpression<?>> docCtx = this.docInputFactory.extractImplementations(collectTask.txnCtx(), collectPhase);
        return new LuceneBatchIterator((IndexSearcher)searcher.item(), queryContext.query(), queryContext.minScore(), Symbols.hasColumn(collectPhase.toCollect(), SysColumns.SCORE), new CollectorContext(sharedShardContext.readerId(), () -> StoredRowLookup.create(shardCreatedVersion, table, this.indexShard.shardId().getIndexName())), docCtx.topLevelInputs(), docCtx.expressions());
    }

    @Override
    @Nullable
    protected BatchIterator<Row> getProjectionFusedIterator(RoutedCollectPhase normalizedPhase, CollectTask collectTask) {
        DocTableInfo table = (DocTableInfo)this.nodeCtx.schemas().getTableInfo(this.relationName);
        BatchIterator<Row> it = GroupByOptimizedIterator.tryOptimizeSingleStringKey(this.indexShard, table, this.luceneQueryBuilder, this.bigArrays, new InputFactory(this.nodeCtx), this.docInputFactory, normalizedPhase, collectTask);
        if (it != null) {
            return it;
        }
        it = DocValuesGroupByOptimizedIterator.tryOptimize(this.nodeCtx.functions(), this.referenceResolver, this.indexShard, table, this.luceneQueryBuilder, this.docInputFactory, normalizedPhase, collectTask);
        if (it != null) {
            return it;
        }
        return DocValuesAggregates.tryOptimize(this.nodeCtx.functions(), this.referenceResolver, this.indexShard, table, this.luceneQueryBuilder, normalizedPhase, collectTask);
    }

    @Override
    public OrderedDocCollector getOrderedCollector(RoutedCollectPhase phase, SharedShardContext sharedShardContext, CollectTask collectTask, boolean requiresRepeat) {
        RefCountedItem<? extends IndexSearcher> searcher = sharedShardContext.acquireSearcher("ordered-collector: " + LuceneShardCollectorProvider.formatSource(phase));
        collectTask.addSearcher(sharedShardContext.readerId(), searcher);
        IndexService indexService = sharedShardContext.indexService();
        DocTableInfo table = (DocTableInfo)this.nodeCtx.schemas().getTableInfo(this.relationName);
        Version shardCreatedVersion = this.indexShard.getVersionCreated();
        LuceneQueryBuilder.Context queryContext = this.luceneQueryBuilder.convert(phase.where(), collectTask.txnCtx(), this.indexShard.shardId().getIndexName(), indexService.indexAnalyzers(), table, shardCreatedVersion, indexService.cache());
        InputFactory.Context<LuceneCollectorExpression<?>> ctx = this.docInputFactory.extractImplementations(collectTask.txnCtx(), phase);
        CollectorContext collectorContext = new CollectorContext(sharedShardContext.readerId(), () -> StoredRowLookup.create(shardCreatedVersion, table, this.indexShard.shardId().getIndexName()));
        int batchSize = phase.shardQueueSize(this.localNodeId.get());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("[{}][{}] creating LuceneOrderedDocCollector. Expected number of rows to be collected: {}", (Object)this.indexShard.routingEntry().currentNodeId(), (Object)this.indexShard.shardId(), (Object)batchSize);
        }
        OptimizeQueryForSearchAfter optimizeQueryForSearchAfter = new OptimizeQueryForSearchAfter(phase.orderBy());
        return new LuceneOrderedDocCollector(this.indexShard.shardId(), (IndexSearcher)searcher.item(), queryContext.query(), queryContext.minScore(), Symbols.hasColumn(phase.toCollect(), SysColumns.SCORE), batchSize, collectTask.getRamAccounting(), collectorContext, optimizeQueryForSearchAfter, LuceneSort.generate(collectTask.txnCtx(), collectorContext, phase.orderBy(), this.docInputFactory), ctx.topLevelInputs(), ctx.expressions());
    }

    static String formatSource(RoutedCollectPhase phase) {
        return phase.jobId().toString() + "-" + phase.phaseId() + "-" + phase.name();
    }
}

