/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.collectors;

import io.crate.common.collections.Lists;
import io.crate.common.concurrent.KillableCompletionStage;
import io.crate.data.BatchIterator;
import io.crate.data.Row;
import io.crate.data.breaker.RowAccounting;
import io.crate.execution.engine.collect.collectors.OrderedDocCollector;
import io.crate.execution.engine.distribution.merge.BatchPagingIterator;
import io.crate.execution.engine.distribution.merge.KeyIterable;
import io.crate.execution.engine.distribution.merge.PagingIterator;
import io.crate.execution.engine.distribution.merge.PassThroughPagingIterator;
import io.crate.execution.engine.distribution.merge.RamAccountingPageIterator;
import io.crate.execution.support.ThreadPools;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.IntSupplier;
import org.elasticsearch.index.shard.ShardId;

public class OrderedLuceneBatchIteratorFactory {
    public static BatchIterator<Row> newInstance(List<OrderedDocCollector> orderedDocCollectors, Comparator<Row> rowComparator, RowAccounting<Row> rowAccounting, Executor executor, IntSupplier availableThreads, boolean requiresScroll) {
        return new Factory(orderedDocCollectors, rowComparator, rowAccounting, executor, availableThreads, requiresScroll).create();
    }

    private static Map<ShardId, OrderedDocCollector> toMapByShardId(List<OrderedDocCollector> collectors) {
        HashMap<ShardId, OrderedDocCollector> collectorsByShardId = new HashMap<ShardId, OrderedDocCollector>(collectors.size());
        for (OrderedDocCollector collector : collectors) {
            collectorsByShardId.put(collector.shardId(), collector);
        }
        return collectorsByShardId;
    }

    private static class Factory {
        private final List<OrderedDocCollector> orderedDocCollectors;
        private final Executor executor;
        private final IntSupplier availableThreads;
        private final PagingIterator<ShardId, Row> pagingIterator;
        private final Map<ShardId, OrderedDocCollector> collectorsByShardId;

        Factory(List<OrderedDocCollector> orderedDocCollectors, Comparator<Row> rowComparator, RowAccounting<Row> rowAccounting, Executor executor, IntSupplier availableThreads, boolean requiresScroll) {
            this.orderedDocCollectors = orderedDocCollectors;
            this.executor = executor;
            this.availableThreads = availableThreads;
            if (orderedDocCollectors.size() == 1) {
                this.pagingIterator = requiresScroll ? new RamAccountingPageIterator(PassThroughPagingIterator.repeatable(), rowAccounting) : PassThroughPagingIterator.oneShot();
                this.collectorsByShardId = null;
            } else {
                this.collectorsByShardId = OrderedLuceneBatchIteratorFactory.toMapByShardId(orderedDocCollectors);
                this.pagingIterator = new RamAccountingPageIterator<ShardId>(PagingIterator.createSorted(rowComparator, requiresScroll), rowAccounting);
            }
        }

        BatchIterator<Row> create() {
            return new BatchPagingIterator<ShardId>(this.pagingIterator, this::tryFetchMore, this::allExhausted, throwable -> this.close());
        }

        private KillableCompletionStage<List<KeyIterable<ShardId, Row>>> tryFetchMore(ShardId shardId) {
            if (this.allExhausted()) {
                return KillableCompletionStage.whenKilled(CompletableFuture.failedFuture(new IllegalStateException("Cannot fetch more if source is exhausted")), t -> {});
            }
            CompletionStage<List<Iterable<Object>>> stage = shardId == null ? ThreadPools.runWithAvailableThreads(this.executor, this.availableThreads, Lists.map(this.orderedDocCollectors, Function.identity())) : Factory.loadFrom(this.collectorsByShardId.get(shardId));
            return KillableCompletionStage.whenKilled(stage, this::kill);
        }

        private static CompletionStage<List<KeyIterable<ShardId, Row>>> loadFrom(OrderedDocCollector collector) {
            try {
                return CompletableFuture.completedFuture(Collections.singletonList(collector.get()));
            }
            catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        }

        private void close() {
            for (OrderedDocCollector collector : this.orderedDocCollectors) {
                collector.close();
            }
        }

        private boolean allExhausted() {
            for (OrderedDocCollector collector : this.orderedDocCollectors) {
                if (collector.exhausted) continue;
                return false;
            }
            return true;
        }

        private void kill(Throwable t) {
            for (OrderedDocCollector collector : this.orderedDocCollectors) {
                collector.kill(t);
            }
        }
    }
}

