/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.collectors;

import io.crate.common.unit.TimeValue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;

public final class ShardStateObserver {
    private static final TimeValue MAX_WAIT_TIME_FOR_NEW_STATE = TimeValue.timeValueSeconds((long)30L);
    private static final Logger LOGGER = LogManager.getLogger(ShardStateObserver.class);
    private final ClusterService clusterService;

    public ShardStateObserver(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public CompletableFuture<ShardRouting> waitForActiveShard(ShardId shardId) {
        ClusterState state = this.clusterService.state();
        try {
            IndexShardRoutingTable routingTable = state.routingTable().shardRoutingTable(shardId);
            ShardRouting primaryShardRouting = routingTable.primaryShard();
            if (primaryShardRouting.started()) {
                return CompletableFuture.completedFuture(primaryShardRouting);
            }
        }
        catch (IndexNotFoundException e) {
            return CompletableFuture.failedFuture(e);
        }
        catch (ShardNotFoundException e) {
            // empty catch block
        }
        ClusterStateObserver stateObserver = new ClusterStateObserver(state, this.clusterService.getClusterApplierService(), MAX_WAIT_TIME_FOR_NEW_STATE, LOGGER);
        RetryIsShardActive listener = new RetryIsShardActive(shardId);
        stateObserver.waitForNextChange((ClusterStateObserver.Listener)listener, newState -> ShardStateObserver.shardStartedOrIndexDeleted(newState, shardId));
        return listener.result();
    }

    private static boolean shardStartedOrIndexDeleted(ClusterState state, ShardId shardId) {
        try {
            return state.routingTable().shardRoutingTable(shardId).primaryShard().started();
        }
        catch (ShardNotFoundException e) {
            return false;
        }
        catch (IndexNotFoundException e) {
            return true;
        }
    }

    private static class RetryIsShardActive
    implements ClusterStateObserver.Listener {
        private final ShardId shardId;
        private final CompletableFuture<ShardRouting> result = new CompletableFuture();

        RetryIsShardActive(ShardId shardId) {
            this.shardId = shardId;
        }

        @Override
        public void onNewClusterState(ClusterState state) {
            try {
                IndexShardRoutingTable routingTable = state.routingTable().shardRoutingTable(this.shardId);
                ShardRouting primaryShardRouting = routingTable.primaryShard();
                if (primaryShardRouting.started()) {
                    this.result.complete(primaryShardRouting);
                }
            }
            catch (Throwable e) {
                this.result.completeExceptionally(e);
            }
        }

        @Override
        public void onClusterServiceClose() {
            this.result.completeExceptionally(new IllegalStateException("ClusterService was closed while waiting for  shard=" + String.valueOf(this.shardId) + " to become active"));
        }

        @Override
        public void onTimeout(TimeValue timeout) {
            this.result.completeExceptionally(new TimeoutException("Timeout waiting for shard=" + String.valueOf(this.shardId) + " to become active"));
        }

        public CompletableFuture<ShardRouting> result() {
            return this.result;
        }
    }
}

