/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.files;

import io.crate.analyze.CopyFromParserProperties;
import io.crate.data.BatchIterator;
import io.crate.data.Input;
import io.crate.data.MappedForwardingBatchIterator;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.FileUriCollectPhase;
import io.crate.execution.engine.collect.files.FileReadingIterator;
import io.crate.execution.engine.collect.files.LineCollectorExpression;
import io.crate.expression.InputRow;
import io.crate.expression.reference.file.LineContext;
import io.crate.operation.collect.files.CSVLineParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class LineProcessor
extends MappedForwardingBatchIterator<FileReadingIterator.LineCursor, Row> {
    private final BatchIterator<FileReadingIterator.LineCursor> source;
    private final LineContext lineContext;
    private final CopyFromParserProperties parserProperties;
    private final List<String> targetColumns;
    private final InputRow row;
    private FileUriCollectPhase.InputFormat inputFormat;
    private CSVLineParser csvLineParser;
    private boolean firstLine = true;

    public LineProcessor(BatchIterator<FileReadingIterator.LineCursor> source, List<Input<?>> inputs, List<LineCollectorExpression<?>> expressions, FileUriCollectPhase.InputFormat inputFormat, CopyFromParserProperties parserProperties, List<String> targetColumns) {
        this.source = source;
        this.inputFormat = inputFormat;
        this.row = new InputRow(inputs);
        this.parserProperties = parserProperties;
        this.targetColumns = targetColumns;
        this.lineContext = new LineContext((FileReadingIterator.LineCursor)source.currentElement());
        for (LineCollectorExpression<?> collectorExpression : expressions) {
            collectorExpression.startCollect(this.lineContext);
        }
    }

    public void moveToStart() {
        this.source.moveToStart();
        this.firstLine = true;
    }

    private boolean readFirstLine(URI currentUri, String line) throws IOException {
        if (LineProcessor.isCSV(this.inputFormat, currentUri)) {
            this.csvLineParser = new CSVLineParser(this.parserProperties, this.targetColumns);
            this.inputFormat = FileUriCollectPhase.InputFormat.CSV;
            if (this.parserProperties.fileHeader()) {
                this.csvLineParser.parseHeader(line);
                return true;
            }
        } else {
            this.inputFormat = FileUriCollectPhase.InputFormat.JSON;
        }
        return false;
    }

    private byte[] getByteArray(String line, long rowNumber) throws IOException {
        if (this.inputFormat == FileUriCollectPhase.InputFormat.CSV) {
            return this.parserProperties.fileHeader() ? this.csvLineParser.parse(line, rowNumber) : this.csvLineParser.parseWithoutHeader(line, rowNumber);
        }
        return line.getBytes(StandardCharsets.UTF_8);
    }

    private static boolean isCSV(FileUriCollectPhase.InputFormat inputFormat, URI currentUri) {
        return inputFormat == FileUriCollectPhase.InputFormat.CSV || currentUri.toString().endsWith(".csv");
    }

    public boolean moveNext() {
        try {
            while (this.source.moveNext()) {
                FileReadingIterator.LineCursor cursor = (FileReadingIterator.LineCursor)this.source.currentElement();
                String line = cursor.line();
                if (line == null) {
                    assert (cursor.failure() != null) : "If the line is null, there must be a failure";
                    return true;
                }
                if (this.firstLine) {
                    this.firstLine = false;
                    if (this.readFirstLine(cursor.uri(), line)) continue;
                }
                try {
                    byte[] json = this.getByteArray(line, cursor.lineNumber());
                    this.lineContext.resetCurrentParsingFailure();
                    this.lineContext.rawSource(json);
                }
                catch (Throwable parseError) {
                    this.lineContext.setCurrentParsingFailure(parseError.getMessage());
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Row currentElement() {
        return this.row;
    }

    protected BatchIterator<FileReadingIterator.LineCursor> delegate() {
        return this.source;
    }
}

