/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.collect.sources;

import io.crate.blob.v2.BlobIndex;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.blob.v2.BlobShard;
import io.crate.execution.engine.collect.BlobShardCollectorProvider;
import io.crate.execution.engine.collect.LuceneShardCollectorProvider;
import io.crate.execution.engine.collect.ShardCollectorProvider;
import io.crate.execution.engine.export.FileOutputFactory;
import io.crate.execution.jobs.NodeLimits;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.NodeContext;
import java.util.Map;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public class ShardCollectorProviderFactory {
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final ElasticsearchClient elasticsearchClient;
    private final BlobIndicesService blobIndicesService;
    private final NodeContext nodeCtx;
    private final LuceneQueryBuilder luceneQueryBuilder;
    private final NodeLimits nodeJobsCounter;
    private final BigArrays bigArrays;
    private final Settings settings;
    private final CircuitBreakerService circuitBreakerService;
    private final Map<String, FileOutputFactory> fileOutputFactoryMap;

    @Inject
    public ShardCollectorProviderFactory(ClusterService clusterService, CircuitBreakerService circuitBreakerService, Settings settings, ThreadPool threadPool, Node node, BlobIndicesService blobIndicesService, NodeContext nodeCtx, LuceneQueryBuilder luceneQueryBuilder, NodeLimits nodeJobsCounter, PageCacheRecycler pageCacheRecycler, Map<String, FileOutputFactory> fileOutputFactoryMap) {
        this.settings = settings;
        this.circuitBreakerService = circuitBreakerService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.elasticsearchClient = node.client();
        this.blobIndicesService = blobIndicesService;
        this.nodeCtx = nodeCtx;
        this.luceneQueryBuilder = luceneQueryBuilder;
        this.nodeJobsCounter = nodeJobsCounter;
        this.bigArrays = new BigArrays(pageCacheRecycler, circuitBreakerService, "query", true);
        this.fileOutputFactoryMap = fileOutputFactoryMap;
    }

    public ShardCollectorProvider create(IndexShard indexShard) {
        if (BlobIndex.isBlobIndex(indexShard.shardId().getIndexName())) {
            BlobShard blobShard = this.blobIndicesService.blobShardSafe(indexShard.shardId());
            return new BlobShardCollectorProvider(blobShard, this.clusterService, this.nodeJobsCounter, this.circuitBreakerService, this.nodeCtx, this.threadPool, this.settings, this.elasticsearchClient, this.fileOutputFactoryMap);
        }
        return new LuceneShardCollectorProvider(this.luceneQueryBuilder, this.clusterService, this.nodeJobsCounter, this.circuitBreakerService, this.nodeCtx, this.threadPool, this.settings, this.elasticsearchClient, indexShard, this.bigArrays, this.fileOutputFactoryMap);
    }
}

