/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.distribution;

import io.crate.Streamer;
import io.crate.data.Bucket;
import io.crate.execution.engine.distribution.StreamBucket;
import io.crate.execution.support.NodeRequest;
import java.io.IOException;
import java.util.UUID;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;
import org.jetbrains.annotations.Nullable;

public class DistributedResultRequest
extends TransportRequest {
    private final byte inputId;
    private final int executionPhaseId;
    private final int bucketIdx;
    private StreamBucket rows;
    private final UUID jobId;
    private boolean isLast = true;
    private Throwable throwable = null;
    private boolean isKilled = false;

    public static NodeRequest<DistributedResultRequest> of(String nodeId, UUID jobId, int executionPhaseId, byte inputId, int bucketIdx, StreamBucket rows, boolean isLast) {
        return new NodeRequest<DistributedResultRequest>(nodeId, new DistributedResultRequest(jobId, executionPhaseId, inputId, bucketIdx, rows, isLast));
    }

    private DistributedResultRequest(UUID jobId, byte inputId, int executionPhaseId, int bucketIdx) {
        this.jobId = jobId;
        this.executionPhaseId = executionPhaseId;
        this.bucketIdx = bucketIdx;
        this.inputId = inputId;
    }

    private DistributedResultRequest(UUID jobId, int executionPhaseId, byte inputId, int bucketIdx, StreamBucket rows, boolean isLast) {
        this(jobId, inputId, executionPhaseId, bucketIdx);
        this.rows = rows;
        this.isLast = isLast;
    }

    private DistributedResultRequest(UUID jobId, int executionPhaseId, byte inputId, int bucketIdx, Throwable throwable, boolean isKilled) {
        this(jobId, inputId, executionPhaseId, bucketIdx);
        this.throwable = throwable;
        this.isKilled = isKilled;
    }

    public UUID jobId() {
        return this.jobId;
    }

    public int executionPhaseId() {
        return this.executionPhaseId;
    }

    public byte executionPhaseInputId() {
        return this.inputId;
    }

    public int bucketIdx() {
        return this.bucketIdx;
    }

    public Bucket readRows(Streamer<?>[] streamers) {
        this.rows.streamers(streamers);
        return this.rows;
    }

    public boolean isLast() {
        return this.isLast;
    }

    @Nullable
    public Throwable throwable() {
        return this.throwable;
    }

    public boolean isKilled() {
        return this.isKilled;
    }

    DistributedResultRequest(StreamInput in) throws IOException {
        super(in);
        this.jobId = new UUID(in.readLong(), in.readLong());
        this.executionPhaseId = in.readVInt();
        this.bucketIdx = in.readVInt();
        this.isLast = in.readBoolean();
        this.inputId = in.readByte();
        boolean failure = in.readBoolean();
        if (failure) {
            this.throwable = in.readException();
            this.isKilled = in.readBoolean();
        } else {
            this.rows = new StreamBucket(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.jobId.getMostSignificantBits());
        out.writeLong(this.jobId.getLeastSignificantBits());
        out.writeVInt(this.executionPhaseId);
        out.writeVInt(this.bucketIdx);
        out.writeBoolean(this.isLast);
        out.writeByte(this.inputId);
        boolean failure = this.throwable != null;
        out.writeBoolean(failure);
        if (failure) {
            out.writeException(this.throwable);
            out.writeBoolean(this.isKilled);
        } else {
            this.rows.writeTo(out);
        }
    }

    public static class Builder {
        public final DistributedResultRequest innerRequest;

        public Builder(UUID jobId, int executionPhaseId, byte inputId, int bucketIdx, Throwable throwable, boolean isKilled) {
            this.innerRequest = new DistributedResultRequest(jobId, executionPhaseId, inputId, bucketIdx, throwable, isKilled);
        }

        public NodeRequest<DistributedResultRequest> build(String nodeId) {
            return new NodeRequest<DistributedResultRequest>(nodeId, this.innerRequest);
        }
    }
}

