/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.export;

import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.execution.engine.export.FileOutput;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.zip.GZIPOutputStream;

public class LocalFsFileOutput
implements FileOutput {
    private final URI uri;

    public LocalFsFileOutput(URI uri) {
        this.uri = uri;
    }

    @Override
    public OutputStream acquireOutputStream(Executor executor, WriterProjection.CompressionType compressionType) throws IOException {
        if (this.uri.getHost() != null) {
            throw new IllegalArgumentException("the URI host must be defined");
        }
        String path = this.uri.getPath();
        File outFile = new File(path);
        if (outFile.exists() && outFile.isDirectory()) {
            throw new IOException("Output path is a directory: " + path);
        }
        OutputStream os = new FileOutputStream(outFile);
        if (compressionType != null) {
            os = new GZIPOutputStream(os);
        }
        return new BufferedOutputStream(os);
    }
}

