/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.indexing;

import io.crate.common.concurrent.ConcurrencyLimit;
import io.crate.common.exceptions.Exceptions;
import io.crate.data.BatchIterator;
import io.crate.data.BatchIterators;
import io.crate.data.CollectionBucket;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.breaker.RamAccounting;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.dml.ShardRequest;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.indexing.BatchIteratorBackpressureExecutor;
import io.crate.execution.engine.indexing.IsUsedBytesOverThreshold;
import io.crate.execution.jobs.NodeLimits;
import io.crate.execution.support.RetryListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.jetbrains.annotations.Nullable;

public class ShardDMLExecutor<TReq extends ShardRequest<TReq, TItem>, TItem extends ShardRequest.Item, TAcc, TResult extends Iterable<? extends Row>>
implements Function<BatchIterator<Row>, CompletableFuture<? extends Iterable<? extends Row>>> {
    public static final int DEFAULT_BULK_SIZE = 10000;
    private final UUID jobId;
    private final int bulkSize;
    private final ScheduledExecutorService scheduler;
    private final Executor executor;
    private final CollectExpression<Row, ?> uidExpression;
    private final NodeLimits nodeLimits;
    private final Supplier<TReq> requestFactory;
    private final Function<String, TItem> itemFactory;
    private final BiConsumer<TReq, ActionListener<ShardResponse>> operation;
    private final Collector<ShardResponse, TAcc, TResult> collector;
    private final String localNode;
    private final CircuitBreaker queryCircuitBreaker;
    private final ClusterService clusterService;
    private int numItems = -1;
    private final RamAccounting ramAccounting;
    public static final Collector<ShardResponse, long[], Iterable<Row>> ROW_COUNT_COLLECTOR = Collector.of(() -> new long[]{0L}, (acc, response) -> {
        ShardDMLExecutor.maybeRaiseFailure(response.failure());
        acc[0] = acc[0] + (long)response.successRowCount();
    }, (acc, response) -> {
        acc[0] = acc[0] + response[0];
        return acc;
    }, acc -> List.of(new Row1((Object)acc[0])), new Collector.Characteristics[0]);
    public static final Collector<ShardResponse, List<Object[]>, Iterable<Row>> RESULT_ROW_COLLECTOR = Collector.of(ArrayList::new, (acc, response) -> {
        ShardDMLExecutor.maybeRaiseFailure(response.failure());
        List<Object[]> rows = response.getResultRows();
        if (rows != null) {
            acc.addAll(rows);
        }
    }, (acc, response) -> {
        acc.addAll(response);
        return acc;
    }, CollectionBucket::new, new Collector.Characteristics[0]);

    public ShardDMLExecutor(UUID jobId, int bulkSize, ScheduledExecutorService scheduler, Executor executor, CollectExpression<Row, ?> uidExpression, ClusterService clusterService, RamAccounting ramAccounting, CircuitBreaker queryCircuitBreaker, NodeLimits nodeLimits, Supplier<TReq> requestFactory, Function<String, TItem> itemFactory, BiConsumer<TReq, ActionListener<ShardResponse>> transportAction, Collector<ShardResponse, TAcc, TResult> collector) {
        this.queryCircuitBreaker = queryCircuitBreaker;
        this.ramAccounting = ramAccounting;
        this.localNode = clusterService.state().nodes().getLocalNodeId();
        this.jobId = jobId;
        this.bulkSize = bulkSize;
        this.scheduler = scheduler;
        this.executor = executor;
        this.uidExpression = uidExpression;
        this.clusterService = clusterService;
        this.nodeLimits = nodeLimits;
        this.requestFactory = requestFactory;
        this.itemFactory = itemFactory;
        this.operation = transportAction;
        this.collector = collector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRowToRequest(TReq req, Row row) {
        ++this.numItems;
        this.uidExpression.setNextRow(row);
        ShardRequest.Item item = (ShardRequest.Item)this.itemFactory.apply((String)this.uidExpression.value());
        RamAccounting ramAccounting = this.ramAccounting;
        synchronized (ramAccounting) {
            this.ramAccounting.addBytes(item.ramBytesUsed());
        }
        ((ShardRequest)req).add(this.numItems, (ShardRequest.Item)item);
    }

    @Nullable
    private String resolveNodeId(TReq request) {
        try {
            ShardRouting primaryShard = this.clusterService.state().routingTable().shardRoutingTable(((ReplicationRequest)request).shardId()).primaryShard();
            return primaryShard == null ? null : primaryShard.currentNodeId();
        }
        catch (IndexNotFoundException | ShardNotFoundException ignored) {
            return null;
        }
    }

    private CompletableFuture<TAcc> executeBatch(final TReq request) {
        final ConcurrencyLimit nodeLimit = this.nodeLimits.get(this.resolveNodeId(request));
        final long startTime = nodeLimit.startSample();
        final CompletableFuture future = new CompletableFuture();
        ActionListener<ShardResponse> listener = new ActionListener<ShardResponse>(){
            final /* synthetic */ ShardDMLExecutor this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(ShardResponse response) {
                nodeLimit.onSample(startTime, false);
                long totalBytesUsed = 0L;
                for (ShardRequest.Item item : request.items()) {
                    totalBytesUsed += item.ramBytesUsed();
                }
                RamAccounting ramAccounting = this.this$0.ramAccounting;
                synchronized (ramAccounting) {
                    this.this$0.ramAccounting.addBytes(-totalBytesUsed);
                }
                Object acc = this.this$0.collector.supplier().get();
                try {
                    this.this$0.collector.accumulator().accept(acc, response);
                    future.complete(acc);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Exception e) {
                nodeLimit.onSample(startTime, true);
                long totalBytesUsed = 0L;
                for (ShardRequest.Item item : request.items()) {
                    totalBytesUsed += item.ramBytesUsed();
                }
                RamAccounting ramAccounting = this.this$0.ramAccounting;
                synchronized (ramAccounting) {
                    this.this$0.ramAccounting.addBytes(-totalBytesUsed);
                }
                future.completeExceptionally(e);
            }
        };
        this.operation.accept(request, this.withRetry(request, nodeLimit, listener));
        return future;
    }

    private RetryListener<ShardResponse> withRetry(TReq request, ConcurrencyLimit nodeLimit, ActionListener<ShardResponse> listener) {
        return new RetryListener<ShardResponse>(this.scheduler, l -> this.operation.accept(request, (ActionListener<ShardResponse>)l), listener, BackoffPolicy.unlimitedDynamic(nodeLimit));
    }

    @Override
    public CompletableFuture<TResult> apply(BatchIterator<Row> batchIterator) {
        ConcurrencyLimit nodeLimit = this.nodeLimits.get(this.localNode);
        IsUsedBytesOverThreshold isUsedBytesOverThreshold = new IsUsedBytesOverThreshold(this.queryCircuitBreaker, nodeLimit);
        BatchIterator reqBatchIterator = BatchIterators.chunks(batchIterator, (int)this.bulkSize, this.requestFactory, this::addRowToRequest, (Predicate)isUsedBytesOverThreshold);
        Predicate<ShardRequest> shouldPause = ignored -> true;
        if (batchIterator.hasLazyResultSet()) {
            shouldPause = req -> this.nodeLimits.get(this.resolveNodeId(req)).exceedsLimit();
        }
        return new BatchIteratorBackpressureExecutor<ShardRequest, TAcc>(this.jobId, this.scheduler, this.executor, reqBatchIterator, this::executeBatch, this.collector.combiner(), this.collector.supplier().get(), shouldPause, null, null, req -> this.nodeLimits.get(this.resolveNodeId(req)).getLastRtt(TimeUnit.MILLISECONDS)).consumeIteratorAndExecute().thenApply(this.collector.finisher());
    }

    public static void maybeRaiseFailure(@Nullable Exception exception) {
        Throwable t;
        if (exception != null && !((t = SQLExceptions.unwrap(exception)) instanceof DocumentMissingException) && !(t instanceof VersionConflictEngineException)) {
            throw Exceptions.toRuntimeException((Throwable)t);
        }
    }
}

