/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.join;

import io.crate.concurrent.CompletionListenable;
import io.crate.data.BatchIterator;
import io.crate.data.CapturingRowConsumer;
import io.crate.data.Input;
import io.crate.data.Paging;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.breaker.RowAccounting;
import io.crate.data.join.CombinedRow;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.join.HashJoinBatchIterator;
import io.crate.execution.engine.join.RamBlockSizeCalculator;
import io.crate.expression.InputFactory;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.TransactionContext;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import org.elasticsearch.common.breaker.CircuitBreaker;

public class HashJoinOperation
implements CompletionListenable {
    private final CapturingRowConsumer leftConsumer;
    private final CapturingRowConsumer rightConsumer;
    private final RowConsumer resultConsumer;

    public HashJoinOperation(int numLeftCols, int numRightCols, RowConsumer nlResultConsumer, Predicate<Row> joinPredicate, List<Symbol> joinLeftInputs, List<Symbol> joinRightInputs, RowAccounting<Object[]> rowAccounting, TransactionContext txnCtx, InputFactory inputFactory, CircuitBreaker circuitBreaker, long estimatedRowSizeForLeft, boolean emitNullValues) {
        this.resultConsumer = nlResultConsumer;
        this.leftConsumer = new CapturingRowConsumer(nlResultConsumer.requiresScroll(), nlResultConsumer.completionFuture());
        this.rightConsumer = new CapturingRowConsumer(true, nlResultConsumer.completionFuture());
        CompletableFuture.allOf(this.leftConsumer.capturedBatchIterator(), this.rightConsumer.capturedBatchIterator()).whenComplete((result, failure) -> {
            if (failure == null) {
                try {
                    BatchIterator<Row> joinIterator = HashJoinOperation.createHashJoinIterator((BatchIterator<Row>)((BatchIterator)this.leftConsumer.capturedBatchIterator().join()), numLeftCols, (BatchIterator<Row>)((BatchIterator)this.rightConsumer.capturedBatchIterator().join()), numRightCols, joinPredicate, HashJoinOperation.getHashBuilderFromSymbols(txnCtx, inputFactory, joinLeftInputs), HashJoinOperation.getHashBuilderFromSymbols(txnCtx, inputFactory, joinRightInputs), rowAccounting, new RamBlockSizeCalculator(Paging.PAGE_SIZE, circuitBreaker, estimatedRowSizeForLeft), emitNullValues);
                    nlResultConsumer.accept(joinIterator, null);
                }
                catch (Exception e) {
                    nlResultConsumer.accept(null, (Throwable)e);
                }
            } else {
                nlResultConsumer.accept(null, failure);
            }
        });
    }

    public CompletableFuture<?> completionFuture() {
        return this.resultConsumer.completionFuture();
    }

    public RowConsumer leftConsumer() {
        return this.leftConsumer;
    }

    public RowConsumer rightConsumer() {
        return this.rightConsumer;
    }

    private static ToIntFunction<Row> getHashBuilderFromSymbols(TransactionContext txnCtx, InputFactory inputFactory, List<Symbol> inputs) {
        InputFactory.Context<CollectExpression<Row, ?>> ctx = inputFactory.ctxForInputColumns(txnCtx, inputs);
        List<Input<?>> topLevelInputs = ctx.topLevelInputs();
        List<CollectExpression<Row, ?>> expressions = ctx.expressions();
        return row -> {
            for (int i = 0; i < expressions.size(); ++i) {
                ((CollectExpression)expressions.get(i)).setNextRow(row);
            }
            int hash = 0;
            for (int i = 0; i < topLevelInputs.size(); ++i) {
                Object value = ((Input)topLevelInputs.get(i)).value();
                hash = 31 * hash + (value == null ? 0 : value.hashCode());
            }
            return hash;
        };
    }

    private static BatchIterator<Row> createHashJoinIterator(BatchIterator<Row> left, int leftNumCols, BatchIterator<Row> right, int rightNumCols, Predicate<Row> joinCondition, ToIntFunction<Row> hashBuilderForLeft, ToIntFunction<Row> hashBuilderForRight, RowAccounting<Object[]> rowAccounting, RamBlockSizeCalculator blockSizeCalculator, boolean emitNullValues) {
        CombinedRow combiner = new CombinedRow(leftNumCols, rightNumCols);
        return new HashJoinBatchIterator(left, right, rowAccounting, combiner, joinCondition, hashBuilderForLeft, hashBuilderForRight, blockSizeCalculator, emitNullValues);
    }
}

