/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.sort;

import io.crate.analyze.OrderBy;
import io.crate.data.Input;
import io.crate.execution.engine.collect.DocInputFactory;
import io.crate.execution.engine.sort.InputFieldComparator;
import io.crate.execution.engine.sort.NullValueOrder;
import io.crate.expression.InputFactory;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.NullSentinelValues;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.DocReferences;
import io.crate.metadata.Reference;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.SysColumns;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.NumericType;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class LuceneSort
extends SymbolVisitor<SortSymbolContext, SortField> {
    private static final SortField SORT_SCORE_REVERSE = new SortField(null, SortField.Type.SCORE, true);
    private static final SortField SORT_SCORE = new SortField(null, SortField.Type.SCORE);
    private final DocInputFactory docInputFactory;

    @Nullable
    public static Sort generate(TransactionContext txnCtx, CollectorContext context, OrderBy orderBy, DocInputFactory docInputFactory) {
        if (orderBy.orderBySymbols().isEmpty()) {
            return null;
        }
        LuceneSort luceneSort = new LuceneSort(docInputFactory);
        SortField[] sortFields = luceneSort.generateSortFields(orderBy.orderBySymbols(), txnCtx, context, orderBy.reverseFlags(), orderBy.nullsFirst());
        return new Sort(sortFields);
    }

    private LuceneSort(DocInputFactory docInputFactory) {
        this.docInputFactory = docInputFactory;
    }

    private SortField[] generateSortFields(List<Symbol> sortSymbols, TransactionContext txnCtx, CollectorContext collectorContext, boolean[] reverseFlags, boolean[] nullsFirst) {
        SortField[] sortFields = new SortField[sortSymbols.size()];
        for (int i = 0; i < sortSymbols.size(); ++i) {
            Symbol sortSymbol = sortSymbols.get(i);
            SortSymbolContext sortSymbolContext = new SortSymbolContext(txnCtx, collectorContext, reverseFlags[i], nullsFirst[i]);
            sortFields[i] = sortSymbol.accept(this, sortSymbolContext);
        }
        return sortFields;
    }

    @Override
    public SortField visitReference(Reference ref, SortSymbolContext context) {
        ColumnIdent columnIdent;
        if (ref.column().isChildOf(SysColumns.DOC)) {
            ref = (Reference)DocReferences.inverseSourceLookup(ref);
        }
        if (SysColumns.SCORE.equals(columnIdent = ref.column())) {
            return !context.reverseFlag ? SORT_SCORE_REVERSE : SORT_SCORE;
        }
        if (SysColumns.RAW.equals(columnIdent) || SysColumns.ID.COLUMN.equals(columnIdent)) {
            return this.customSortField(SysColumns.nameForLucene(columnIdent), ref, context);
        }
        if (!ref.hasDocValues()) {
            return this.customSortField(ref.toString(), ref, context);
        }
        DataType<?> dataType = ref.valueType();
        if (dataType instanceof NumericType) {
            NumericType numericType = (NumericType)dataType;
            Integer precision = numericType.numericPrecision();
            if (precision == null || precision > 18) {
                return this.customSortField(ref.toString(), ref, context);
            }
            SortedNumericSortField sortField = new SortedNumericSortField(ref.storageIdent(), SortField.Type.LONG, context.reverseFlag, context.reverseFlag ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN);
            boolean min = NullValueOrder.fromFlag(context.nullFirst) == NullValueOrder.FIRST ^ context.reverseFlag;
            sortField.setMissingValue((Object)(min ? -1000000000000000000L : 1000000000000000000L));
            return sortField;
        }
        if (ref.valueType().equals(DataTypes.IP) || ref.valueType().id() == 25 || ref.valueType().id() == 28) {
            return this.customSortField(ref.toString(), ref, context);
        }
        NullValueOrder nullValueOrder = NullValueOrder.fromFlag(context.nullFirst);
        return LuceneSort.mappedSortField(ref, context.reverseFlag, nullValueOrder);
    }

    @VisibleForTesting
    static SortField mappedSortField(Reference symbol, boolean reverse, NullValueOrder nullValueOrder) {
        String fieldName = symbol.storageIdent();
        DataType<?> valueType = symbol.valueType();
        switch (valueType.id()) {
            case 4: 
            case 27: {
                SortedSetSortField sortField = new SortedSetSortField(fieldName, reverse, reverse ? SortedSetSelector.Type.MAX : SortedSetSelector.Type.MIN);
                sortField.setMissingValue(nullValueOrder == NullValueOrder.LAST ^ reverse ? SortedSetSortField.STRING_LAST : SortedSetSortField.STRING_FIRST);
                return sortField;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                SortedNumericSelector.Type selectorType = reverse ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
                SortedNumericSortField sortField = new SortedNumericSortField(fieldName, SortField.Type.LONG, reverse, selectorType);
                sortField.setOptimizeSortWithPoints(false);
                sortField.setMissingValue(NullSentinelValues.nullSentinel(DataTypes.LONG, nullValueOrder, reverse));
                return sortField;
            }
            case 7: {
                SortedNumericSelector.Type selectorType = reverse ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
                SortedNumericSortField sortField = new SortedNumericSortField(fieldName, SortField.Type.FLOAT, reverse, selectorType);
                sortField.setMissingValue(NullSentinelValues.nullSentinel(DataTypes.FLOAT, nullValueOrder, reverse));
                return sortField;
            }
            case 6: {
                SortedNumericSelector.Type selectorType = reverse ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
                SortedNumericSortField sortField = new SortedNumericSortField(fieldName, SortField.Type.DOUBLE, reverse, selectorType);
                sortField.setMissingValue(NullSentinelValues.nullSentinel(DataTypes.DOUBLE, nullValueOrder, reverse));
                return sortField;
            }
            case 13: {
                throw new IllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
            }
        }
        throw new UnsupportedOperationException("Cannot order on " + String.valueOf(symbol) + "::" + String.valueOf(valueType));
    }

    @Override
    public SortField visitFunction(Function function, SortSymbolContext context) {
        return this.customSortField(function.toString(), function, context);
    }

    @Override
    public SortField visitAlias(AliasSymbol aliasSymbol, SortSymbolContext context) {
        return aliasSymbol.symbol().accept(this, context);
    }

    @Override
    protected SortField visitSymbol(Symbol symbol, SortSymbolContext context) {
        throw new UnsupportedOperationException(Symbols.format("Using a non-integer constant in ORDER BY is not supported", symbol));
    }

    private SortField customSortField(String name, final Symbol symbol, SortSymbolContext context) {
        InputFactory.Context<LuceneCollectorExpression<?>> inputContext = this.docInputFactory.getCtx(context.txnCtx);
        final Input<?> input = inputContext.add(symbol);
        final List<? extends LuceneCollectorExpression<?>> expressions = inputContext.expressions();
        final CollectorContext collectorContext = context.context;
        final boolean nullFirst = context.nullFirst;
        return new SortField(name, new FieldComparatorSource(this){

            public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
                for (int i = 0; i < expressions.size(); ++i) {
                    ((LuceneCollectorExpression)expressions.get(i)).startCollect(collectorContext);
                }
                DataType<Object> dataType = symbol.valueType();
                Object nullSentinel = NullSentinelValues.nullSentinel(dataType, NullValueOrder.fromFlag(nullFirst), reversed);
                return new InputFieldComparator(numHits, expressions, input, nullSentinel == null ? (nullFirst ^ reversed ? Comparator.nullsFirst(dataType) : Comparator.nullsLast(dataType)) : dataType, nullSentinel);
            }
        }, context.reverseFlag);
    }

    record SortSymbolContext(TransactionContext txnCtx, CollectorContext context, boolean reverseFlag, boolean nullFirst) {
    }
}

