/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.window;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.window.WindowFrameState;
import io.crate.execution.engine.window.WindowFunction;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.Nullable;

public class RowNumberWindowFunction
implements WindowFunction {
    private static final String NAME = "row_number";
    private final Signature signature;
    private final BoundSignature boundSignature;

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(NAME, FunctionType.WINDOW).argumentTypes(new TypeSignature[0]).returnType(DataTypes.INTEGER.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), RowNumberWindowFunction::new);
    }

    private RowNumberWindowFunction(Signature signature, BoundSignature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Object execute(LongConsumer allocateBytes, int idxInPartition, WindowFrameState currentFrame, List<? extends CollectExpression<Row, ?>> expressions, @Nullable Boolean ignoreNulls, Input<?> ... args) {
        if (ignoreNulls != null) {
            throw new IllegalArgumentException("row_number cannot accept RESPECT or IGNORE NULLS flag.");
        }
        return idxInPartition + 1;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public BoundSignature boundSignature() {
        return this.boundSignature;
    }
}

