/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.engine.window;

import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class WindowFrameState {
    private final List<Object[]> rows;
    private int lowerBound;
    private int upperBoundExclusive;
    private int partitionStart;
    private int partitionEnd;

    WindowFrameState(int lowerBound, int upperBoundExclusive, List<Object[]> rows) {
        this.lowerBound = lowerBound;
        this.upperBoundExclusive = upperBoundExclusive;
        this.rows = rows;
    }

    public int lowerBound() {
        return this.lowerBound;
    }

    public int upperBoundExclusive() {
        return this.upperBoundExclusive;
    }

    public int partitionEnd() {
        return this.partitionEnd;
    }

    public Iterable<Object[]> getRows() {
        return this.rows;
    }

    public int size() {
        return this.upperBoundExclusive - this.lowerBound;
    }

    @Nullable
    public Object[] getRowInFrameAtIndexOrNull(int index) {
        if (index < this.lowerBound || index >= this.upperBoundExclusive) {
            return null;
        }
        int globalIdx = this.partitionStart + index;
        return this.rows.get(globalIdx);
    }

    public Object[] getRowInPartitionAtIndexOrNull(int index) {
        int idxInPartition = this.partitionStart + index;
        if (idxInPartition < this.partitionStart || idxInPartition >= this.partitionEnd) {
            return null;
        }
        return this.rows.get(idxInPartition);
    }

    void updateBounds(int pStart, int pEnd, int wBegin, int wEnd) {
        this.partitionStart = pStart;
        this.partitionEnd = pEnd;
        this.lowerBound = wBegin - pStart;
        this.upperBoundExclusive = wEnd - pStart;
    }

    public String toString() {
        return "WindowFrameState{lowerBound=" + this.lowerBound + ", upperBoundExclusive=" + this.upperBoundExclusive + ", partitionStart=" + this.partitionStart + ", partitionEnd=" + this.partitionEnd + "}";
    }

    public static boolean isLowerBoundIncreasing(WindowFrameState frame, int prevLowerBound) {
        return prevLowerBound < frame.lowerBound();
    }
}

