/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import com.carrotsearch.hppc.IntIndexedContainer;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.execution.dsl.phases.CountPhase;
import io.crate.execution.engine.collect.count.CountOperation;
import io.crate.execution.jobs.AbstractTask;
import io.crate.metadata.TransactionContext;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class CountTask
extends AbstractTask {
    private final CountPhase countPhase;
    private final TransactionContext txnCtx;
    private final CountOperation countOperation;
    private final RowConsumer consumer;
    private final Map<String, IntIndexedContainer> indexShardMap;
    private CompletableFuture<Long> countFuture;
    private volatile Throwable killReason;

    CountTask(CountPhase countPhase, TransactionContext txnCtx, CountOperation countOperation, RowConsumer consumer, Map<String, IntIndexedContainer> indexShardMap) {
        super(countPhase.phaseId());
        this.countPhase = countPhase;
        this.txnCtx = txnCtx;
        this.countOperation = countOperation;
        this.consumer = consumer;
        this.indexShardMap = indexShardMap;
    }

    @Override
    public synchronized CompletableFuture<Void> innerStart() {
        try {
            this.countFuture = this.countOperation.count(this.txnCtx, this.indexShardMap, this.countPhase.where());
        }
        catch (Throwable t) {
            this.consumer.accept(null, t);
            return null;
        }
        this.countFuture.whenComplete((rowCount, failure) -> {
            Throwable killed = this.killReason;
            Throwable throwable = failure = killed == null ? failure : killed;
            if (failure == null) {
                this.consumer.accept(InMemoryBatchIterator.of((Object)new Row1(rowCount), (Object)SentinelRow.SENTINEL), null);
                this.close();
            } else {
                this.consumer.accept(null, failure);
                this.kill((Throwable)failure);
            }
        });
        return null;
    }

    @Override
    public synchronized void innerKill(@NotNull Throwable throwable) {
        if (this.countFuture == null) {
            this.consumer.accept(null, throwable);
        } else {
            this.killReason = throwable;
            this.countFuture.cancel(true);
        }
    }

    @Override
    public String name() {
        return this.countPhase.name();
    }

    @Override
    public long bytesUsed() {
        return -1L;
    }
}

