/*
 * Decompiled with CFR 0.152.
 */
package io.crate.execution.jobs;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.crate.concurrent.CountdownFuture;
import io.crate.exceptions.TaskMissing;
import io.crate.execution.engine.collect.stats.JobsLogs;
import io.crate.execution.jobs.RootTask;
import io.crate.execution.jobs.kill.KillAllListener;
import io.crate.role.Role;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.NoSuchNodeException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class TasksService
extends AbstractLifecycleComponent
implements TransportConnectionListener {
    private static final Logger LOGGER = LogManager.getLogger(TasksService.class);
    private final ClusterService clusterService;
    private final JobsLogs jobsLogs;
    private final ConcurrentMap<UUID, RootTask> activeTasks = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
    private final List<KillAllListener> killAllListeners = new CopyOnWriteArrayList<KillAllListener>();
    private final Object failedSentinel = new Object();
    private final Cache<UUID, Object> recentlyFailed = Caffeine.newBuilder().executor(Runnable::run).maximumSize(200L).expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private final TransportService transportService;

    @Inject
    public TasksService(ClusterService clusterService, TransportService transportService, JobsLogs jobsLogs) {
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.jobsLogs = jobsLogs;
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        this.transportService.addConnectionListener(this);
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        this.transportService.removeConnectionListener(this);
        for (RootTask rootTask : this.activeTasks.values()) {
            rootTask.kill("TasksService stopped");
        }
    }

    public void addListener(KillAllListener listener) {
        this.killAllListeners.add(listener);
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    public RootTask getTask(UUID jobId) {
        RootTask rootTask = (RootTask)this.activeTasks.get(jobId);
        if (rootTask == null) {
            throw new TaskMissing(TaskMissing.Type.ROOT, jobId);
        }
        return rootTask;
    }

    @Override
    public void onNodeDisconnected(DiscoveryNode node, Transport.Connection connection) {
        for (RootTask task : this.activeTasks.values()) {
            if (!task.participatingNodes().contains(node.getId())) continue;
            task.kill("Participating node " + node.getId() + " disconnected");
        }
    }

    @VisibleForTesting
    public Stream<UUID> getJobIdsByParticipatingNodes(String nodeId) {
        return this.activeTasks.values().stream().filter(i -> i.participatingNodes().contains(nodeId)).map(RootTask::jobId);
    }

    @Nullable
    public RootTask getTaskOrNull(UUID jobId) {
        return (RootTask)this.activeTasks.get(jobId);
    }

    @VisibleForTesting
    public RootTask.Builder newBuilder(UUID jobId) {
        return new RootTask.Builder(LOGGER, jobId, Role.CRATE_USER.name(), this.clusterService.localNode().getId(), Collections.emptySet(), this.jobsLogs);
    }

    public RootTask.Builder newBuilder(UUID jobId, String user, String coordinatorNodeId, Collection<String> participatingNodes) {
        return new RootTask.Builder(LOGGER, jobId, user, coordinatorNodeId, participatingNodes, this.jobsLogs);
    }

    public int numActive() {
        return this.activeTasks.size();
    }

    public RootTask createTask(RootTask.Builder builder) throws Exception {
        if (builder.isEmpty()) {
            throw new IllegalArgumentException("RootTask.Builder must at least contain 1 Task");
        }
        UUID jobId = builder.jobId();
        RootTask newRootTask = builder.build();
        TaskCallback taskCallback = new TaskCallback(jobId);
        newRootTask.completionFuture().whenComplete((BiConsumer)taskCallback);
        RootTask existing = this.activeTasks.putIfAbsent(jobId, newRootTask);
        if (existing != null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "task for job %s already exists:%n%s", jobId, existing));
        }
        DiscoveryNodes nodes = this.clusterService.state().nodes();
        for (String participatingNode : newRootTask.participatingNodes()) {
            if (nodes.nodeExists(participatingNode)) continue;
            NoSuchNodeException noSuchNodeException = new NoSuchNodeException(participatingNode);
            taskCallback.accept(null, noSuchNodeException);
            throw noSuchNodeException;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("RootTask created for job={} tasks={} totalTasks={}", (Object)jobId, (Object)builder.size(), (Object)this.activeTasks.size());
        }
        return newRootTask;
    }

    public CompletableFuture<Integer> killAll(String userName) {
        List<UUID> toKill;
        boolean isSuperUser = userName.equals(Role.CRATE_USER.name());
        if (isSuperUser) {
            for (KillAllListener killAllListener : this.killAllListeners) {
                try {
                    killAllListener.killAllJobs();
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to call killAllJobs on listener={} error={}", (Object)killAllListener, (Object)t);
                }
            }
        }
        if ((toKill = List.copyOf(this.activeTasks.keySet())).isEmpty()) {
            return CompletableFuture.completedFuture(0);
        }
        return this.killTasks(toKill, userName, null);
    }

    private CompletableFuture<Integer> killTasks(Collection<UUID> toKill, String userName, @Nullable String reason) {
        assert (!toKill.isEmpty()) : "toKill must not be empty";
        int numKilled = 0;
        CountdownFuture countDownFuture = new CountdownFuture(toKill.size());
        boolean isSuperUser = userName.equals(Role.CRATE_USER.name());
        for (UUID jobId : toKill) {
            RootTask ctx = (RootTask)this.activeTasks.get(jobId);
            if (ctx == null) {
                countDownFuture.onSuccess();
                continue;
            }
            if (isSuperUser || ctx.userName().equals(userName)) {
                this.recentlyFailed.put((Object)jobId, this.failedSentinel);
                ctx.completionFuture().whenComplete((BiConsumer)countDownFuture);
                ctx.kill(reason);
                ++numKilled;
                continue;
            }
            countDownFuture.onSuccess();
        }
        int finalNumKilled = numKilled;
        return countDownFuture.handle((r, f) -> finalNumKilled);
    }

    public CompletableFuture<Integer> killJobs(Collection<UUID> toKill, String userName, @Nullable String reason) {
        boolean isSuperUser = userName.equals(Role.CRATE_USER.name());
        if (isSuperUser) {
            for (KillAllListener killAllListener : this.killAllListeners) {
                for (UUID job : toKill) {
                    try {
                        killAllListener.killJob(job);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Failed to call killJob on listener={}, err={}", (Object)killAllListener, (Object)t);
                    }
                }
            }
        }
        return this.killTasks(toKill, userName, reason);
    }

    public boolean recentlyFailed(UUID jobId) {
        return this.recentlyFailed.getIfPresent((Object)jobId) == this.failedSentinel;
    }

    @VisibleForTesting
    public void logActiveTasksToError() {
        if (LOGGER.isErrorEnabled()) {
            String localNodeId = this.clusterService.localNode().getId();
            for (Map.Entry entry : this.activeTasks.entrySet()) {
                LOGGER.error("Active task node={} jobId={}, task={}", (Object)localNodeId, entry.getKey(), entry.getValue());
            }
        }
    }

    private class TaskCallback
    implements BiConsumer<Void, Throwable> {
        private final UUID jobId;

        TaskCallback(UUID jobId) {
            this.jobId = jobId;
        }

        @Override
        public void accept(Void aVoid, Throwable throwable) {
            TasksService.this.activeTasks.remove(this.jobId);
            if (throwable != null) {
                TasksService.this.recentlyFailed.put((Object)this.jobId, TasksService.this.failedSentinel);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("RootTask removed from active tasks: jobId={} remainingTasks={} failure={}", (Object)this.jobId, (Object)TasksService.this.activeTasks.size(), (Object)throwable);
            }
        }
    }
}

