/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.eval;

import io.crate.analyze.relations.FieldResolver;
import io.crate.data.Input;
import io.crate.expression.predicate.MatchPredicate;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.scalar.arithmetic.MapFunction;
import io.crate.expression.symbol.AliasSymbol;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.FunctionCopyVisitor;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.WindowFunction;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.TransactionContext;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluatingNormalizer {
    private static final Logger LOGGER = LogManager.getLogger(EvaluatingNormalizer.class);
    private final NodeContext nodeCtx;
    private final RowGranularity granularity;
    private final ReferenceResolver<? extends Input<?>> referenceResolver;
    private final FieldResolver fieldResolver;
    private final BaseVisitor visitor;
    private final Predicate<Function> onFunctionCondition;

    public static EvaluatingNormalizer functionOnlyNormalizer(NodeContext nodeCtx) {
        return new EvaluatingNormalizer(nodeCtx, RowGranularity.CLUSTER, null, null);
    }

    public static EvaluatingNormalizer functionOnlyNormalizer(NodeContext nodeCtx, Predicate<Function> onFunctionCondition) {
        return new EvaluatingNormalizer(nodeCtx, RowGranularity.CLUSTER, null, null, onFunctionCondition);
    }

    public EvaluatingNormalizer(NodeContext nodeCtx, RowGranularity granularity, @Nullable ReferenceResolver<? extends Input<?>> referenceResolver, @Nullable FieldResolver fieldResolver) {
        this(nodeCtx, granularity, referenceResolver, fieldResolver, function -> true);
    }

    public EvaluatingNormalizer(NodeContext nodeCtx, RowGranularity granularity, @Nullable ReferenceResolver<? extends Input<?>> referenceResolver, @Nullable FieldResolver fieldResolver, Predicate<Function> onFunctionCondition) {
        this.nodeCtx = nodeCtx;
        this.granularity = granularity;
        this.referenceResolver = referenceResolver;
        this.fieldResolver = fieldResolver;
        this.visitor = new BaseVisitor();
        this.onFunctionCondition = onFunctionCondition;
    }

    public Symbol normalize(@Nullable Symbol symbol, @NotNull TransactionContext txnCtx) {
        if (symbol == null) {
            return null;
        }
        return symbol.accept(this.visitor, txnCtx);
    }

    private class BaseVisitor
    extends FunctionCopyVisitor<TransactionContext> {
        private BaseVisitor() {
        }

        @Override
        public Symbol visitField(ScopedSymbol field, TransactionContext context) {
            Symbol resolved;
            if (EvaluatingNormalizer.this.fieldResolver != null && (resolved = EvaluatingNormalizer.this.fieldResolver.resolveField(field)) != null) {
                return resolved;
            }
            return field;
        }

        @Override
        public Symbol visitMatchPredicate(io.crate.expression.symbol.MatchPredicate matchPredicate, TransactionContext context) {
            if (EvaluatingNormalizer.this.fieldResolver != null) {
                Map<Symbol, Symbol> fieldBoostMap = matchPredicate.identBoostMap();
                ArrayList<Symbol> columnBoostMapArgs = new ArrayList<Symbol>(fieldBoostMap.size() * 2);
                for (Map.Entry<Symbol, Symbol> entry : fieldBoostMap.entrySet()) {
                    Symbol resolved = entry.getKey().accept(this, null);
                    if (resolved instanceof Reference) {
                        Reference ref = (Reference)resolved;
                        columnBoostMapArgs.add(Literal.of(ref.storageIdent()));
                        columnBoostMapArgs.add(entry.getValue());
                        continue;
                    }
                    return matchPredicate;
                }
                final List<Symbol> arguments = List.of(new Function(MapFunction.SIGNATURE, columnBoostMapArgs, DataTypes.UNTYPED_OBJECT).accept(this, context), matchPredicate.queryTerm().accept(this, context), Literal.of(matchPredicate.matchType()), matchPredicate.options().accept(this, context));
                FunctionImplementation implementation = EvaluatingNormalizer.this.nodeCtx.functions().get(null, "match", arguments, context.sessionSettings().searchPath());
                return new Function(this, implementation.signature(), arguments, DataTypes.BOOLEAN){

                    @Override
                    public void writeTo(StreamOutput out) throws IOException {
                        if (out.getVersion().onOrAfter(Version.V_4_2_4)) {
                            super.writeTo(out);
                        } else {
                            MatchPredicate.TEXT_MATCH.writeAsFunctionInfo(out, MatchPredicate.TEXT_MATCH.getArgumentDataTypes());
                            if (out.getVersion().onOrAfter(Version.V_4_1_0)) {
                                Symbol.nullableToStream(this.filter, out);
                            }
                            Symbols.toStream(arguments, out);
                            if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
                                out.writeBoolean(true);
                                this.signature.writeTo(out);
                                DataTypes.toStream(this.returnType, out);
                            }
                        }
                    }
                };
            }
            HashMap<Symbol, Symbol> fieldBoostMap = new HashMap<Symbol, Symbol>(matchPredicate.identBoostMap().size());
            for (Map.Entry<Symbol, Symbol> entry : matchPredicate.identBoostMap().entrySet()) {
                fieldBoostMap.put(entry.getKey().accept(this, context), entry.getValue().accept(this, context));
            }
            return new io.crate.expression.symbol.MatchPredicate(fieldBoostMap, matchPredicate.queryTerm().accept(this, context), matchPredicate.matchType(), matchPredicate.options().accept(this, context));
        }

        @Override
        public Symbol visitReference(Reference symbol, TransactionContext context) {
            if (EvaluatingNormalizer.this.referenceResolver == null || symbol.granularity().ordinal() > EvaluatingNormalizer.this.granularity.ordinal()) {
                return symbol;
            }
            Input<?> input = EvaluatingNormalizer.this.referenceResolver.getImplementation(symbol);
            if (input != null) {
                return Literal.ofUnchecked(symbol.valueType(), input.value());
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(Symbols.format("Can't resolve reference %s", symbol));
            }
            return symbol;
        }

        @Override
        public Symbol visitFunction(Function function, TransactionContext context) {
            return this.normalizeFunction(function, context);
        }

        private Symbol normalizeFunction(Function function, TransactionContext context) {
            if (!EvaluatingNormalizer.this.onFunctionCondition.test(function)) {
                return function;
            }
            function = this.processAndMaybeCopy(function, context);
            FunctionImplementation implementation = EvaluatingNormalizer.this.nodeCtx.functions().getQualified(function);
            assert (implementation != null) : "Function implementation not found using full qualified lookup: " + String.valueOf(function);
            return implementation.normalizeSymbol(function, context, EvaluatingNormalizer.this.nodeCtx);
        }

        @Override
        public Symbol visitWindowFunction(WindowFunction function, TransactionContext context) {
            Function normalizedFunction = (Function)this.normalizeFunction(function, context);
            return new WindowFunction(normalizedFunction.signature(), normalizedFunction.arguments(), normalizedFunction.valueType(), normalizedFunction.filter(), function.windowDefinition().map(s -> s.accept(this, context)), function.ignoreNulls());
        }

        @Override
        public Symbol visitAlias(AliasSymbol aliasSymbol, TransactionContext context) {
            return aliasSymbol.symbol().accept(this, context);
        }
    }
}

