/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.planner.operators.Filter;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class AndOperator
extends Operator<Boolean> {
    public static final String NAME = "op_and";
    public static final Signature SIGNATURE = Signature.builder("op_and", FunctionType.SCALAR).argumentTypes(DataTypes.BOOLEAN.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature()).returnType(DataTypes.BOOLEAN.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build();

    public static void register(Functions.Builder builder) {
        builder.add(SIGNATURE, AndOperator::new);
    }

    public AndOperator(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    public Symbol normalizeSymbol(Function function, TransactionContext txnCtx, NodeContext nodeCtx) {
        assert (function != null) : "function must not be null";
        assert (function.arguments().size() == 2) : "number of args must be 2";
        Symbol left = function.arguments().get(0);
        Symbol right = function.arguments().get(1);
        if (left instanceof Input && right instanceof Input) {
            return Literal.of((Boolean)this.evaluate(txnCtx, nodeCtx, new Input[]{(Input)left, (Input)right}));
        }
        if (left instanceof Input) {
            Input leftInput = (Input)left;
            Object value = leftInput.value();
            if (value == null) {
                return function;
            }
            if (((Boolean)value).booleanValue()) {
                return right;
            }
            return Literal.of(false);
        }
        if (right instanceof Input) {
            Input rightInput = (Input)right;
            Object value = rightInput.value();
            if (value == null) {
                return function;
            }
            if (((Boolean)value).booleanValue()) {
                return left;
            }
            return Literal.of(false);
        }
        return function;
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Boolean> ... args) {
        assert (args != null) : "args must not be null";
        assert (args.length == 2) : "number of args must be 2";
        assert (args[0] != null && args[1] != null) : "1st and 2nd arguments must not be null";
        Boolean left = (Boolean)args[0].value();
        Boolean right = (Boolean)args[1].value();
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right == false ? Boolean.valueOf(false) : null;
        }
        if (right == null) {
            return left == false ? Boolean.valueOf(false) : null;
        }
        return left != false && right != false;
    }

    @Override
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        for (Symbol symbol : function.arguments()) {
            query.add(symbol.accept(context.visitor(), context), BooleanClause.Occur.MUST);
        }
        return query.build();
    }

    public static Function of(Symbol first, Symbol second) {
        assert (first.valueType().equals(DataTypes.BOOLEAN) || first.valueType().equals(DataTypes.UNDEFINED)) : "first symbol must have BOOLEAN return type to create AND function";
        assert (second.valueType().equals(DataTypes.BOOLEAN) || second.valueType().equals(DataTypes.UNDEFINED)) : "second symbol must have BOOLEAN return type to create AND function";
        return new Function(SIGNATURE, List.of(first, second), Operator.RETURN_TYPE);
    }

    public static Symbol join(Iterable<? extends Symbol> symbols) {
        return AndOperator.join(symbols.iterator());
    }

    public static Symbol join(Iterator<? extends Symbol> symbols) {
        return AndOperator.join(symbols, Literal.BOOLEAN_TRUE);
    }

    public static Symbol join(Iterable<? extends Symbol> symbols, Symbol defaultSymbol) {
        return AndOperator.join(symbols.iterator(), defaultSymbol);
    }

    public static Symbol join(Iterator<? extends Symbol> symbols, Symbol defaultSymbol) {
        if (!symbols.hasNext()) {
            return defaultSymbol;
        }
        Symbol first = symbols.next();
        while (symbols.hasNext()) {
            Symbol next = symbols.next();
            if (Filter.isMatchAll(next)) continue;
            first = new Function(SIGNATURE, List.of(first, next), Operator.RETURN_TYPE);
        }
        return first;
    }

    public static List<Symbol> split(Symbol predicate) {
        ArrayList<Symbol> conjunctions = new ArrayList<Symbol>();
        predicate.accept(SplitVisitor.INSTANCE, conjunctions);
        if (conjunctions.isEmpty()) {
            conjunctions.add(predicate);
        }
        return conjunctions;
    }

    static class SplitVisitor
    extends SymbolVisitor<List<Symbol>, Symbol> {
        private static final SplitVisitor INSTANCE = new SplitVisitor();

        SplitVisitor() {
        }

        @Override
        protected Symbol visitSymbol(Symbol symbol, List<Symbol> context) {
            return symbol;
        }

        @Override
        public Symbol visitFunction(Function func, List<Symbol> conjunctions) {
            Signature signature = func.signature();
            assert (signature != null) : "Expecting functions signature not to be null";
            if (signature.equals(SIGNATURE)) {
                for (Symbol argument : func.arguments()) {
                    Symbol result = argument.accept(this, conjunctions);
                    if (result == null) continue;
                    conjunctions.add(result);
                }
                return null;
            }
            return func;
        }
    }
}

