/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.data.Input;
import io.crate.expression.operator.EqOperator;
import io.crate.expression.operator.Operator;
import io.crate.expression.predicate.IsNullPredicate;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.ObjectType;
import io.crate.types.TypeSignature;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;

public class DistinctFrom
extends Operator<Object> {
    public static final String NAME = "op_IS DISTINCT FROM";
    public static final Signature SIGNATURE = Signature.builder("op_IS DISTINCT FROM", FunctionType.SCALAR).argumentTypes(TypeSignature.parse("E"), TypeSignature.parse("E")).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.NOTNULL).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build();
    private final DataType<Object> argType;

    public static void register(Functions.Builder builder) {
        builder.add(SIGNATURE, DistinctFrom::new);
    }

    private DistinctFrom(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        this.argType = boundSignature.argTypes().getFirst();
    }

    @Override
    public Symbol normalizeSymbol(Function function, TransactionContext txnCtx, NodeContext nodeCtx) {
        try {
            return DistinctFrom.evaluateIfLiterals(this, txnCtx, nodeCtx, function);
        }
        catch (Throwable t) {
            return function;
        }
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args.length == 2) : "number of arguments must be 2";
        Object arg1 = args[0].value();
        Object arg2 = args[1].value();
        if (arg1 == null && arg2 == null) {
            return false;
        }
        if (arg1 == null || arg2 == null) {
            return true;
        }
        return this.argType.compare(arg1, arg2) != 0;
    }

    @Override
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        Reference ref;
        Symbol symbol;
        block11: {
            block10: {
                List<Symbol> args = function.arguments();
                symbol = args.get(0);
                if (!(symbol instanceof Reference)) break block10;
                ref = (Reference)symbol;
                symbol = args.get(1);
                if (symbol instanceof Literal) break block11;
            }
            return null;
        }
        Literal literal = (Literal)symbol;
        String storageIdentifier = ref.storageIdent();
        Object value = literal.value();
        if (value == null) {
            if (!ref.isNullable()) {
                return new MatchAllDocsQuery();
            }
            return IsNullPredicate.refExistsQuery(ref, context);
        }
        DataType<?> dataType = ref.valueType();
        return switch (dataType.id()) {
            case 12 -> EqOperator.refEqObject(function, ref.column(), (ObjectType)dataType, (Map)value, context, BooleanClause.Occur.MUST_NOT);
            case 100 -> EqOperator.termsAndGenericFilter(function, storageIdentifier, dataType, (Collection)value, context, ref.hasDocValues(), ref.indexType(), BooleanClause.Occur.MUST_NOT);
            default -> {
                Query query = EqOperator.fromPrimitive(dataType, storageIdentifier, value, ref.hasDocValues(), ref.indexType());
                if (query == null) {
                    yield null;
                }
                yield Queries.not(query);
            }
        };
    }
}

