/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator;

import io.crate.expression.operator.LikeOperator;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.all.AllLikeOperator;
import io.crate.expression.operator.all.AllNotLikeOperator;
import io.crate.expression.operator.any.AnyLikeOperator;
import io.crate.expression.operator.any.AnyNotLikeOperator;
import io.crate.lucene.match.CrateRegexQuery;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.sql.tree.ArrayComparison;
import io.crate.types.DataTypes;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.jetbrains.annotations.Nullable;

public class LikeOperators {
    public static final String OP_LIKE = "op_like";
    public static final String OP_ILIKE = "op_ilike";
    public static final String ANY_LIKE = "any_like";
    public static final String ANY_ILIKE = "any_ilike";
    public static final String ANY_NOT_LIKE = "any_not_like";
    public static final String ANY_NOT_ILIKE = "any_not_ilike";
    public static final String ALL_LIKE = "_all_like";
    public static final String ALL_ILIKE = "_all_ilike";
    public static final String ALL_NOT_LIKE = "_all_not_like";
    public static final String ALL_NOT_ILIKE = "_all_not_ilike";
    public static final Character DEFAULT_ESCAPE = Character.valueOf('\\');
    public static final String DEFAULT_ESCAPE_STR = "\\";

    public static String likeOperatorName(boolean ignoreCase) {
        return ignoreCase ? OP_ILIKE : OP_LIKE;
    }

    public static String arrayOperatorName(ArrayComparison.Quantifier q, boolean negate, boolean ignoreCase) {
        return switch (q) {
            case ArrayComparison.Quantifier.ANY -> {
                if (negate) {
                    yield ignoreCase ? ANY_NOT_ILIKE : ANY_NOT_LIKE;
                }
                yield ignoreCase ? ANY_ILIKE : ANY_LIKE;
            }
            case ArrayComparison.Quantifier.ALL -> {
                if (negate) {
                    yield ignoreCase ? ALL_NOT_ILIKE : ALL_NOT_LIKE;
                }
                yield ignoreCase ? ALL_ILIKE : ALL_LIKE;
            }
            default -> throw new IllegalStateException("An invalid array operator: " + String.valueOf(q));
        };
    }

    public static void register(Functions.Builder builder) {
        builder.add(Signature.builder(OP_LIKE, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new LikeOperator((Signature)signature, (BoundSignature)boundSignature, LikeOperators::matches, CaseSensitivity.SENSITIVE));
        builder.add(Signature.builder(OP_ILIKE, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.STRICTNULL, Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new LikeOperator((Signature)signature, (BoundSignature)boundSignature, LikeOperators::matches, CaseSensitivity.INSENSITIVE));
        builder.add(Signature.builder(OP_LIKE, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new LikeOperator((Signature)signature, (BoundSignature)boundSignature, LikeOperators::matches, CaseSensitivity.SENSITIVE));
        builder.add(Signature.builder(OP_ILIKE, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).build(), (signature, boundSignature) -> new LikeOperator((Signature)signature, (BoundSignature)boundSignature, LikeOperators::matches, CaseSensitivity.INSENSITIVE));
        builder.add(Signature.builder(ANY_LIKE, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING_ARRAY.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new AnyLikeOperator((Signature)signature, (BoundSignature)boundSignature, CaseSensitivity.SENSITIVE));
        builder.add(Signature.builder(ANY_NOT_LIKE, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING_ARRAY.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new AnyNotLikeOperator((Signature)signature, (BoundSignature)boundSignature, CaseSensitivity.SENSITIVE));
        builder.add(Signature.builder(ANY_ILIKE, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING_ARRAY.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new AnyLikeOperator((Signature)signature, (BoundSignature)boundSignature, CaseSensitivity.INSENSITIVE));
        builder.add(Signature.builder(ANY_NOT_ILIKE, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING_ARRAY.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new AnyNotLikeOperator((Signature)signature, (BoundSignature)boundSignature, CaseSensitivity.INSENSITIVE));
        builder.add(Signature.builder(ALL_LIKE, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING_ARRAY.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new AllLikeOperator((Signature)signature, (BoundSignature)boundSignature, CaseSensitivity.SENSITIVE));
        builder.add(Signature.builder(ALL_NOT_LIKE, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING_ARRAY.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new AllNotLikeOperator((Signature)signature, (BoundSignature)boundSignature, CaseSensitivity.SENSITIVE));
        builder.add(Signature.builder(ALL_ILIKE, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING_ARRAY.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new AllLikeOperator((Signature)signature, (BoundSignature)boundSignature, CaseSensitivity.INSENSITIVE));
        builder.add(Signature.builder(ALL_NOT_ILIKE, FunctionType.SCALAR).argumentTypes(DataTypes.STRING.getTypeSignature(), DataTypes.STRING_ARRAY.getTypeSignature()).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC, Scalar.Feature.STRICTNULL).build(), (signature, boundSignature) -> new AllNotLikeOperator((Signature)signature, (BoundSignature)boundSignature, CaseSensitivity.INSENSITIVE));
    }

    static final Pattern makePattern(String pattern, CaseSensitivity caseSensitivity, Character escape) {
        return Pattern.compile(LikeOperators.patternToRegex(pattern, escape), caseSensitivity.patternFlags());
    }

    public static boolean matches(String expression, String pattern, Character escape, CaseSensitivity caseSensitivity) {
        return LikeOperators.makePattern(pattern, caseSensitivity, escape).matcher(expression).matches();
    }

    public static String patternToRegex(String patternString, @Nullable Character escapeChar) {
        StringBuilder regex = new StringBuilder(patternString.length() * 2);
        regex.append('^');
        boolean escaped = false;
        block7: for (char currentChar : patternString.toCharArray()) {
            if (escapeChar != null && !escaped && currentChar == escapeChar.charValue()) {
                escaped = true;
                continue;
            }
            switch (currentChar) {
                case '%': {
                    if (escaped) {
                        regex.append("%");
                    } else {
                        regex.append(".*");
                    }
                    escaped = false;
                    continue block7;
                }
                case '_': {
                    if (escaped) {
                        regex.append("_");
                    } else {
                        regex.append('.');
                    }
                    escaped = false;
                    continue block7;
                }
                default: {
                    switch (currentChar) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '.': 
                        case '?': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': {
                            regex.append('\\');
                            break;
                        }
                    }
                    regex.append(currentChar);
                    escaped = false;
                }
            }
        }
        if (escaped) {
            LikeOperators.throwErrorForTrailingEscapeChar(patternString, escapeChar);
        }
        regex.append('$');
        return regex.toString();
    }

    public static String convertSqlLikeToLuceneWildcard(String wildcardString) {
        StringBuilder regex = new StringBuilder();
        boolean escaped = false;
        block7: for (char currentChar : wildcardString.toCharArray()) {
            if (!escaped && currentChar == DEFAULT_ESCAPE.charValue()) {
                escaped = true;
                continue;
            }
            switch (currentChar) {
                case '%': {
                    regex.append(escaped ? (char)'%' : '*');
                    escaped = false;
                    continue block7;
                }
                case '_': {
                    regex.append(escaped ? (char)'_' : '?');
                    escaped = false;
                    continue block7;
                }
                default: {
                    switch (currentChar) {
                        case '*': 
                        case '?': 
                        case '\\': {
                            regex.append('\\');
                            break;
                        }
                    }
                    regex.append(currentChar);
                    escaped = false;
                }
            }
        }
        if (escaped) {
            LikeOperators.throwErrorForTrailingEscapeChar(wildcardString, DEFAULT_ESCAPE);
        }
        return regex.toString();
    }

    public static void throwErrorForTrailingEscapeChar(String pattern, Character escapeChar) {
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "pattern '%s' must not end with escape character '%s'", pattern, escapeChar));
    }

    public static enum CaseSensitivity {
        SENSITIVE{

            @Override
            public Query likeQuery(String fqColumn, String pattern, Character escapeChar, boolean isIndexed) {
                if (isIndexed) {
                    String luceneWildcard = LikeOperators.convertSqlLikeToLuceneWildcard(pattern);
                    Term term = new Term(fqColumn, luceneWildcard);
                    return new WildcardQuery(term);
                }
                return null;
            }

            @Override
            public int patternFlags() {
                return 32;
            }
        }
        ,
        INSENSITIVE{

            @Override
            public Query likeQuery(String fqColumn, String pattern, Character escapeChar, boolean isIndexed) {
                if (isIndexed) {
                    String regex = LikeOperators.patternToRegex(pattern, escapeChar);
                    Term term = new Term(fqColumn, regex);
                    return new CrateRegexQuery(term, 66);
                }
                return null;
            }

            @Override
            public int patternFlags() {
                return 34;
            }
        };


        @Nullable
        public abstract Query likeQuery(String var1, String var2, Character var3, boolean var4);

        public abstract int patternFlags();
    }
}

