/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.all;

import io.crate.expression.operator.LikeOperators;
import io.crate.expression.operator.all.AllOperator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.Reference;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import org.apache.lucene.search.Query;

public final class AllLikeOperator
extends AllOperator<String> {
    private final LikeOperators.CaseSensitivity caseSensitivity;

    public AllLikeOperator(Signature signature, BoundSignature boundSignature, LikeOperators.CaseSensitivity caseSensitivity) {
        super(signature, boundSignature);
        this.caseSensitivity = caseSensitivity;
        DataType innerType = ((ArrayType)boundSignature.argTypes().get(1)).innerType();
        if (innerType.id() == 12) {
            throw new IllegalArgumentException("ALL on object arrays is not supported");
        }
    }

    @Override
    boolean matches(String probe, String candidate) {
        return LikeOperators.matches(probe, candidate, LikeOperators.DEFAULT_ESCAPE, this.caseSensitivity) || LikeOperators.matches(candidate, probe, LikeOperators.DEFAULT_ESCAPE, this.caseSensitivity);
    }

    @Override
    protected Query refMatchesAllArrayLiteral(Function all, Reference probe, Literal<?> literal, LuceneQueryBuilder.Context context) {
        return null;
    }

    @Override
    protected Query literalMatchesAllArrayRef(Function all, Literal<?> probe, Reference candidates, LuceneQueryBuilder.Context context) {
        return null;
    }

    @Override
    protected void validateRightArg(String arg) {
        if (arg.endsWith("\\")) {
            LikeOperators.throwErrorForTrailingEscapeChar(arg, LikeOperators.DEFAULT_ESCAPE);
        }
    }
}

