/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.any;

import io.crate.expression.operator.EqOperator;
import io.crate.expression.operator.any.AnyOperator;
import io.crate.expression.predicate.IsNullPredicate;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.IndexType;
import io.crate.metadata.Reference;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.sql.tree.ComparisonExpression;
import io.crate.types.ArrayType;
import io.crate.types.DataTypes;
import io.crate.types.EqQuery;
import io.crate.types.StorageSupport;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lucene.search.Queries;

public final class AnyNeqOperator
extends AnyOperator<Object> {
    public static String NAME = "any_" + ComparisonExpression.Type.NOT_EQUAL.getValue();

    AnyNeqOperator(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
    }

    @Override
    boolean matches(Object probe, Object candidate) {
        return this.leftType.compare(probe, candidate) != 0;
    }

    @Override
    protected Query refMatchesAnyArrayLiteral(Function any, Reference probe, Literal<?> candidates, LuceneQueryBuilder.Context context) {
        if (ArrayType.dimensions(candidates.valueType()) > 1) {
            return null;
        }
        List<?> nonNullValues = AnyNeqOperator.filterNullValues(candidates);
        if (nonNullValues.isEmpty()) {
            return new MatchNoDocsQuery("Cannot match unless there is at least one non-null candidate");
        }
        String columnName = probe.storageIdent();
        BooleanQuery.Builder andBuilder = new BooleanQuery.Builder();
        for (Object value : nonNullValues) {
            Query fromPrimitive = EqOperator.fromPrimitive(probe.valueType(), columnName, value, probe.hasDocValues(), probe.indexType());
            if (fromPrimitive == null) {
                return null;
            }
            andBuilder.add(fromPrimitive, BooleanClause.Occur.MUST);
        }
        Query exists = IsNullPredicate.refExistsQuery(probe, context);
        return new BooleanQuery.Builder().add(Queries.not((Query)andBuilder.build()), BooleanClause.Occur.MUST).add(exists, BooleanClause.Occur.FILTER).build();
    }

    @Override
    protected Query literalMatchesAnyArrayRef(Function any, Literal<?> probe, Reference candidates, LuceneQueryBuilder.Context context) {
        if (DataTypes.isArray(probe.valueType())) {
            return null;
        }
        String columnName = candidates.storageIdent();
        StorageSupport<?> storageSupport = probe.valueType().storageSupport();
        if (storageSupport == null) {
            return null;
        }
        EqQuery<?> eqQuery = storageSupport.eqQuery();
        if (eqQuery == null) {
            return null;
        }
        Object value = probe.value();
        BooleanQuery.Builder query = new BooleanQuery.Builder();
        query.setMinimumNumberShouldMatch(1);
        Query gt = eqQuery.rangeQuery(columnName, value, null, false, false, candidates.hasDocValues(), candidates.indexType() != IndexType.NONE);
        Query lt = eqQuery.rangeQuery(columnName, null, value, false, false, candidates.hasDocValues(), candidates.indexType() != IndexType.NONE);
        if (lt == null || gt == null) {
            assert (lt != null || gt == null) : "If lt is null, gt must be null";
            return null;
        }
        query.add(gt, BooleanClause.Occur.SHOULD);
        query.add(lt, BooleanClause.Occur.SHOULD);
        return query.build();
    }
}

