/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.operator.any;

import io.crate.data.Input;
import io.crate.expression.operator.Operator;
import io.crate.expression.operator.any.AnyEqOperator;
import io.crate.expression.operator.any.AnyLikeOperator;
import io.crate.expression.operator.any.AnyNeqOperator;
import io.crate.expression.operator.any.AnyNotLikeOperator;
import io.crate.expression.operator.any.AnyRangeOperator;
import io.crate.expression.scalar.ArrayUnnestFunction;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.lucene.LuceneQueryBuilder;
import io.crate.metadata.FunctionProvider;
import io.crate.metadata.FunctionType;
import io.crate.metadata.Functions;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.BoundSignature;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.apache.lucene.search.Query;

public abstract sealed class AnyOperator<T>
extends Operator<T>
permits AnyEqOperator, AnyNeqOperator, AnyRangeOperator, AnyLikeOperator, AnyNotLikeOperator {
    public static final String OPERATOR_PREFIX = "any_";
    public static final List<String> OPERATOR_NAMES = List.of(AnyEqOperator.NAME, AnyNeqOperator.NAME, AnyRangeOperator.Comparison.GT.opName(), AnyRangeOperator.Comparison.GTE.opName(), AnyRangeOperator.Comparison.LT.opName(), AnyRangeOperator.Comparison.LTE.opName(), "any_like", "any_ilike", "any_not_like", "any_not_ilike");
    protected final DataType<T> leftType;

    public static void register(Functions.Builder builder) {
        AnyOperator.reg(builder, AnyEqOperator.NAME, AnyEqOperator::new);
        AnyOperator.reg(builder, AnyNeqOperator.NAME, AnyNeqOperator::new);
        AnyOperator.regRange(builder, AnyRangeOperator.Comparison.GT);
        AnyOperator.regRange(builder, AnyRangeOperator.Comparison.GTE);
        AnyOperator.regRange(builder, AnyRangeOperator.Comparison.LT);
        AnyOperator.regRange(builder, AnyRangeOperator.Comparison.LTE);
    }

    private static void regRange(Functions.Builder builder, AnyRangeOperator.Comparison comparison) {
        AnyOperator.reg(builder, comparison.opName(), (sig, boundSig) -> new AnyRangeOperator((Signature)sig, (BoundSignature)boundSig, comparison));
    }

    private static void reg(Functions.Builder builder, String name, FunctionProvider.FunctionFactory operatorFactory) {
        builder.add(Signature.builder(name, FunctionType.SCALAR).argumentTypes(TypeSignature.parse("E"), TypeSignature.parse("array(E)")).returnType(Operator.RETURN_TYPE.getTypeSignature()).features(Scalar.Feature.DETERMINISTIC).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).build(), operatorFactory);
    }

    protected static List<?> filterNullValues(Literal<?> literal) {
        assert (ArrayType.dimensions(literal.valueType()) == 1) : "The literal must be 1D array";
        return StreamSupport.stream(((Iterable)literal.value()).spliterator(), false).filter(Objects::nonNull).toList();
    }

    AnyOperator(Signature signature, BoundSignature boundSignature) {
        super(signature, boundSignature);
        this.leftType = boundSignature.argTypes().get(0);
    }

    abstract boolean matches(T var1, T var2);

    protected abstract Query refMatchesAnyArrayLiteral(Function var1, Reference var2, Literal<?> var3, LuceneQueryBuilder.Context var4);

    protected abstract Query literalMatchesAnyArrayRef(Function var1, Literal<?> var2, Reference var3, LuceneQueryBuilder.Context var4);

    protected void validateRightArg(T arg) {
    }

    @Override
    @SafeVarargs
    public final Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<T> ... args) {
        assert (args != null) : "args must not be null";
        assert (args.length == 2) : "number of args must be 2";
        assert (args[0] != null) : "1st argument must not be null";
        Object item = args[0].value();
        Object items = args[1].value();
        if (items == null || item == null) {
            return null;
        }
        boolean anyNulls = false;
        for (Object rightValue : (Iterable)items) {
            if (rightValue == null) {
                anyNulls = true;
                continue;
            }
            this.validateRightArg(rightValue);
            if (!this.matches(item, rightValue)) continue;
            return true;
        }
        return anyNulls ? null : Boolean.valueOf(false);
    }

    @Override
    public Query toQuery(Function function, LuceneQueryBuilder.Context context) {
        Function fn;
        List<Symbol> args = function.arguments();
        Symbol probe = args.get(0);
        Symbol candidates = args.get(1);
        while (candidates instanceof Function && (fn = (Function)candidates).signature().equals(ArrayUnnestFunction.SIGNATURE)) {
            candidates = fn.arguments().get(0);
        }
        if (probe instanceof Literal) {
            Literal literal = (Literal)probe;
            if (candidates instanceof Reference) {
                Reference ref = (Reference)candidates;
                return this.literalMatchesAnyArrayRef(function, literal, ref, context);
            }
        }
        if (probe instanceof Reference) {
            Reference ref = (Reference)probe;
            if (candidates instanceof Literal) {
                Literal literal = (Literal)candidates;
                return this.refMatchesAnyArrayLiteral(function, ref, literal, context);
            }
        }
        return null;
    }
}

