/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.expression.reference.doc.lucene.StoredRowLookup;
import io.crate.metadata.Reference;
import java.util.function.Supplier;

public class CollectorContext {
    private final int readerId;
    private final Supplier<StoredRowLookup> storedRowLookupSupplier;
    private StoredRowLookup storedRowLookup;

    public CollectorContext(Supplier<StoredRowLookup> storedRowLookupSupplier) {
        this(-1, storedRowLookupSupplier);
    }

    public CollectorContext(int readerId, Supplier<StoredRowLookup> storedRowLookupSupplier) {
        this.readerId = readerId;
        this.storedRowLookupSupplier = storedRowLookupSupplier;
    }

    public int readerId() {
        return this.readerId;
    }

    public StoredRowLookup storedRowLookup() {
        if (this.storedRowLookup == null) {
            this.storedRowLookup = this.storedRowLookupSupplier.get();
        }
        this.storedRowLookup.registerAll();
        return this.storedRowLookup;
    }

    public StoredRowLookup storedRowLookup(Reference ref) {
        if (this.storedRowLookup == null) {
            this.storedRowLookup = this.storedRowLookupSupplier.get();
        }
        this.storedRowLookup.registerRef(ref);
        return this.storedRowLookup;
    }
}

