/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import io.crate.execution.engine.fetch.ReaderContext;
import io.crate.expression.reference.doc.lucene.CollectorContext;
import io.crate.expression.reference.doc.lucene.LuceneCollectorExpression;
import io.crate.expression.reference.doc.lucene.StoredRow;
import io.crate.expression.reference.doc.lucene.StoredRowLookup;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.SysColumns;
import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class DocCollectorExpression<T>
extends LuceneCollectorExpression<T> {
    protected final Reference ref;
    private StoredRowLookup storedRowLookup;
    private ReaderContext context;
    protected StoredRow source;

    protected DocCollectorExpression(Reference ref) {
        this.ref = ref;
    }

    @Override
    public final void startCollect(CollectorContext context) {
        this.storedRowLookup = context.storedRowLookup(this.ref);
    }

    @Override
    public final void setNextDocId(int doc) {
        this.source = this.storedRowLookup.getStoredRow(this.context, doc);
    }

    @Override
    public final void setNextReader(ReaderContext context) throws IOException {
        this.context = context;
    }

    public static LuceneCollectorExpression<?> create(Reference reference, Predicate<Reference> isParentReferenceIgnored) {
        assert (reference.column().name().equals(SysColumns.DOC.name())) : "column name must be " + SysColumns.DOC.name();
        if (reference.column().isRoot()) {
            return new RootDocCollectorExpression(reference);
        }
        Function<Object, Object> valueConverter = isParentReferenceIgnored.test(reference) ? val -> reference.valueType().sanitizeValueLenient(val) : val -> val;
        return new ChildDocCollectorExpression(reference, valueConverter);
    }

    static final class RootDocCollectorExpression
    extends DocCollectorExpression<Map<String, Object>> {
        private RootDocCollectorExpression(Reference ref) {
            super(ref);
        }

        public Map<String, Object> value() {
            return this.source.asMap();
        }
    }

    static final class ChildDocCollectorExpression
    extends DocCollectorExpression<Object> {
        private final Function<Object, Object> valueConverter;

        private ChildDocCollectorExpression(Reference ref, Function<Object, Object> valueConverter) {
            super(ref);
            this.valueConverter = valueConverter;
        }

        public Object value() {
            return this.valueConverter.apply(this.source.get(this.ref.column().path()));
        }
    }
}

