/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.doc.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;

public class RawFieldVisitor
extends StoredFieldVisitor {
    private final Map<String, Object> storedValues = new HashMap<String, Object>();
    private static final Set<String> IGNORED_FIELDS = Set.of("_recovery_source", "_id");

    public Map<String, Object> getStoredValues() {
        return this.storedValues;
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        if (IGNORED_FIELDS.contains(fieldInfo.name)) {
            return StoredFieldVisitor.Status.NO;
        }
        return StoredFieldVisitor.Status.YES;
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        this.storedValues.put(fieldInfo.name, new BytesRef(value).toString());
    }

    public void stringField(FieldInfo fieldInfo, String value) throws IOException {
        this.storedValues.put(fieldInfo.name, value);
    }

    public void intField(FieldInfo fieldInfo, int value) throws IOException {
        this.storedValues.put(fieldInfo.name, value);
    }

    public void longField(FieldInfo fieldInfo, long value) throws IOException {
        this.storedValues.put(fieldInfo.name, value);
    }

    public void floatField(FieldInfo fieldInfo, float value) throws IOException {
        this.storedValues.put(fieldInfo.name, Float.valueOf(value));
    }

    public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
        this.storedValues.put(fieldInfo.name, value);
    }
}

