/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.reference.sys.check.node;

import io.crate.expression.reference.sys.check.SysCheck;
import io.crate.expression.reference.sys.check.node.AbstractSysNodeCheck;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.monitor.fs.FsService;

abstract class DiskWatermarkNodesSysCheck
extends AbstractSysNodeCheck {
    private static final Logger LOGGER = LogManager.getLogger(DiskWatermarkNodesSysCheck.class);
    private final FsService fsService;
    final DiskThresholdSettings diskThresholdSettings;

    DiskWatermarkNodesSysCheck(int id, String description, SysCheck.Severity severity, ClusterService clusterService, FsService fsService, Settings settings) {
        super(id, description, severity);
        this.fsService = fsService;
        this.diskThresholdSettings = new DiskThresholdSettings(settings, clusterService.getClusterSettings());
    }

    @Override
    public boolean isValid() {
        try {
            if (!this.diskThresholdSettings.isEnabled()) {
                return true;
            }
            FsInfo.Path leastAvailablePath = this.getLeastAvailablePath();
            return this.isValid(leastAvailablePath.getAvailable().getBytes(), leastAvailablePath.getTotal().getBytes());
        }
        catch (IOException e) {
            LOGGER.error("Unable to determine the node disk usage while validating high/low disk watermark check: ", (Throwable)e);
            return false;
        }
    }

    protected abstract boolean isValid(long var1, long var3);

    FsInfo.Path getLeastAvailablePath() throws IOException {
        FsInfo.Path leastAvailablePath = null;
        for (FsInfo.Path info : this.fsService.stats()) {
            if (leastAvailablePath == null) {
                leastAvailablePath = info;
                continue;
            }
            if (leastAvailablePath.getAvailable().getBytes() <= info.getAvailable().getBytes()) continue;
            leastAvailablePath = info;
        }
        assert (leastAvailablePath != null) : "must be at least one path";
        return leastAvailablePath;
    }

    static double getFreeDiskAsPercentage(long free, long total) {
        if (total == 0L) {
            return 100.0;
        }
        return 100.0 * ((double)free / (double)total);
    }
}

